use strict;
use warnings;
use Module::Build::CipUX;

use version; our $VERSION = qv('3.4.0.8');

my $builder = Module::Build::CipUX->new(
    module_name   => 'CipUX::RPC',
    license       => 'gpl2',
    dist_author   => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version  => $VERSION,
    dist_abstract => 'CipUX XML-RPC server',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    #    verbose            => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic'  => 0,
        'Readonly::XS'        => 0,
        'Test::Pod::Coverage' => 0,
    },

    build_requires => {
        'Test::More'           => 0,
        'Test::Pod'            => '1.14',
        'Test::Pod::Coverage'  => '1.04',
        'Module::Build::CipUX' => '0.3.0',
        'Test::Refcount'       => 0,
        'Test::LeakTrace'      => 0,
    },

    requires => {
        'Authen::Simple::PAM'      => 0,
        'Authen::Simple::Password' => 0,
        'Carp'                     => 0,
        'CipUX'                    => '3.4.0.4',
        'CipUX::RBAC::Simple'      => '3.4.0.0',
        'CipUX::Task'              => '3.4.0.6',
        'Class::Std'               => '0.0.9',
        'Cwd'                      => 0,
        'Data::Dumper'             => 0,
        'Date::Manip'              => 0,
        'English'                  => 0,
        'Fatal'                    => 0,
        'File::stat'               => 0,
        'Frontier::Client'         => 0,
        'Frontier::Daemon'         => 0,
        'Frontier::RPC2'           => 0,
        'Getopt::Long'             => 0,
        'List::MoreUtils'          => 0,
        'Log::Log4perl'            => 0,
        'Log::Dispatch'            => 0,
        'Pod::Usage'               => 0,
        'Readonly'                 => 0,
        'Ticket::Simple'           => 0,
        'version'                  => 0,
    },

    # ADD to BUILD target
    stunnel_files =>
        { 'etc/cipux/stunnel/readme.txt' => 'stunnel/readme.txt', },

    # ADD to INSTALL target
    install_path => { stunnel => 'etc/cipux/stunnel', },

    add_to_cleanup => ['CipUX-RPC-*'],
);

# new BUILD target
$builder->add_build_element('stunnel');

$builder->create_build_script();
