/* cp_special.c   Routines that can be tried out without recompiling rest
of programs. There is button allowing selection of 5 different specials.*/

#include "cp_head.h"
extern char *get_selection();
Menu special_menu;

/* ==========Must update this menu when routines change=============== */

void handle_special_proc();

create_special_menu() /* menu attached to "Special button" */
{
	special_menu=menu_create(MENU_STRINGS,
		"approx radii using exp(z^3)",
		"approx radii using exp(z^2)",
		"combine radii",
		"compute rad ratio, p2",
		"decrease bdry angle sums",
		"Shrink to square","Shrink/expand","Shrink to strip",
		0,
		MENU_NOTIFY_PROC,handle_special_proc,
		0);
} /* create_special_menu */

int
special1(datastr) /* use info about p2 (domain packing) with constant
radii to set approximate radii of p1 (range packing) to approximate 
"exp(z^3)". Results to p1. Assume same complex, both eucl. 
p2 is regular hex packing, radii given by rad, center point given by  
(m*(2*rad),n*(rad+sqr(3)*rad*I). Default to rad=1, m=n=0.  */
char *datastr;
{
	int next,pnum1,pnum2,flag=0,i,m,n,cmdcount;
	float rad,mf,nf;
	complex z,w;
	struct p_data *p1,*p2;
	struct R_data *pR_ptr1,*pR_ptr2;
	struct K_data *pK_ptr1;

	if ( (cmdcount=sscanf(datastr,"%d %d %lf %d %d",
		&pnum1,&pnum2,&rad,&m,&n))>2
		&& pnum1 >= 0 && pnum1 < NUM_PACKS 
		&& pnum2 >= 0 && pnum2 < NUM_PACKS
		&& pnum1 != pnum2 
		&& packdata[pnum1].status && packdata[pnum2].status 
		&& packdata[pnum1].nodecount==packdata[pnum2].nodecount)
	 {
		p1=&packdata[pnum1];
		p2=&packdata[pnum2];
		pR_ptr1=p1->packR_ptr;  pR_ptr2=p2->packR_ptr;
		pK_ptr1=p1->packK_ptr;  
		if (p1->hes!=0 || p2->hes!=0)
		 {
			strcpy(msgbuf,"Packs are not both euclidean.");
			emsg();
			return 0;
		 }
		rad = (cmdcount>2 && rad>0) ? rad : 1.0;
		for (i=1;i<=p1->nodecount;i++)
			pR_ptr2[i].rad=rad;
		comp_pack_centers(p2);
		next=p1->beta;
		while (!flag || next!=p1->beta) /* set boundary radii only*/
		 {
		   mf = (cmdcount>3) ? (float)m: 0;
		   nf = (cmdcount>4) ? (float)n: 0;
		   z.re = pR_ptr2[next].center.re + 2*mf*rad + nf*rad;
		   z.im = pR_ptr2[next].center.im + nf*sqrt(3.0)*rad;
		   w=cmult(cmult(z,z),z);	   
		   pR_ptr1[next].rad=exp(w.re);
		   next=pK_ptr1[next].flower[0];
		   flag=1;
		 }
		fillcurves(p1);
		sprintf(msgbuf,"Approx bdry radii are stored in %d.",pnum1);
		msg();
		return 1;
	 }
	strcpy(msgbuf,"Usage: special1 p q x m n. q=domain,p=range,x=rad,m,n tell starting circle.");
	emsg();
	return 0;
} /* special1 */

int
special2(datastr) /* same as special1, only use the exponential "exp(z^2)".*/
char *datastr;
{
	int next,pnum1,pnum2,flag=0,i,m,n,cmdcount;
	float modsq,rad,mf,nf;
	complex z;
	struct p_data *p1,*p2;
	struct R_data *pR_ptr1,*pR_ptr2;
	struct K_data *pK_ptr1;

	if ( (cmdcount=sscanf(datastr,"%d %d %lf %d %d",
		&pnum1,&pnum2,&rad,&m,&n))>2
		&& pnum1 >= 0 && pnum1 < NUM_PACKS 
		&& pnum2 >= 0 && pnum2 < NUM_PACKS
		&& pnum1 != pnum2 
		&& packdata[pnum1].status && packdata[pnum2].status 
		&& packdata[pnum1].nodecount==packdata[pnum2].nodecount)
	 {
		p1=&packdata[pnum1];
		p2=&packdata[pnum2];
		pR_ptr1=p1->packR_ptr;  pR_ptr2=p2->packR_ptr;
		pK_ptr1=p1->packK_ptr;  
		if (p1->hes!=0 || p2->hes!=0)
		 {
			strcpy(msgbuf,"Packs are not both euclidean.");
			emsg();
			return 0;
		 }
		rad = (cmdcount>2 && rad>0) ? rad : 1.0;
		for (i=1;i<=p1->nodecount;i++)
			pR_ptr2[i].rad=rad;
		comp_pack_centers(p2);
		next=p1->beta;
		while (!flag || next!=p1->beta) /* set boundary radii only*/
		 {
		   mf = (cmdcount>3) ? (float)m: 0;
		   nf = (cmdcount>4) ? (float)n: 0;
		   z.re = pR_ptr2[next].center.re + 2*mf*rad + nf*rad;
		   z.im = pR_ptr2[next].center.im + nf*sqrt(3.0)*rad;	   
		   modsq=(z.re*z.re - z.im*z.im);
		   pR_ptr1[next].rad=exp(modsq);
		   next=pK_ptr1[next].flower[0];
		   flag=1;
		 }
		fillcurves(p1);
		sprintf(msgbuf,"Approx bdry radii are stored in %d.",pnum1);
		msg();
		return 1;
	 }
	strcpy(msgbuf,"Usage: special2 p q x m n. q=domain,p=range,x=rad,m,n tell starting circle.");
	emsg();
	return 0;
} /* special2 */
 
int
special3(datastr) /* Get new eucl radii from old: copy p1 to p3;
bdry data from p1 and p2 is combined according to specified `cmd' to get
new bdry data for p3. */
char *datastr;
{
	int j,pnum1,pnum2,pnum3;
	char buff[10];
	struct p_data *p1,*p2,*p3;
	struct K_data *pK_ptr1;
	struct R_data *pR_ptr1,*pR_ptr2,*pR_ptr3;

	if ( sscanf(datastr,"%d %d %d %s",
		&pnum1,&pnum2,&pnum3,buff)==4
		&& pnum1 >= 0 && pnum1 < NUM_PACKS 
		&& pnum2 >= 0 && pnum2 < NUM_PACKS
		&& pnum3 >= 0 && pnum3 < NUM_PACKS
		&& packdata[pnum1].status && packdata[pnum2].status 
		&& packdata[pnum1].hes==0 && packdata[pnum2].hes==0
		&& packdata[pnum1].nodecount==packdata[pnum2].nodecount)
	 {
		p1=&packdata[pnum1];
		p2=&packdata[pnum2];
		p3=&packdata[pnum3];
		pK_ptr1=p1->packK_ptr;
		pR_ptr1=p1->packR_ptr;
		pR_ptr2=p2->packR_ptr;
		pR_ptr3=p3->packR_ptr;
		/* sprintf(buf,"copy -p%d %d",pnum1,pnum3);
		handle_cmd(buf); */
		if (buff[0]=='a') /* add */
		 {
			for (j=1;j<=p1->nodecount;j++)
			 {
			   if (pK_ptr1[j].bdry_flag)
			    {
				pR_ptr3[j].rad=pR_ptr1[j].rad+pR_ptr2[j].rad;
			    }
			 }
		 }
		else return 0;
	 }
	else
	 {
		sprintf(msgbuf,"Special9 error: p1 and p2 eucl?");
		emsg();
		return 0;
	 }
	return 1;
} /* special3 */

int
special4(datastr) /* special routine 4. For a eucl pack 2, compute largest ratio
of radii of two neighbors. */
char *datastr;
{
	register int i,j;
	float mr,ratio;

	if (!packdata[2].status || packdata[2].hes!=0) 
	 {
		strcpy(msgbuf,"Pack 2 is empty or is not eucl. Try again.");
		emsg();
		return 0;
	 }
	mr=0.0;
	for (i=1;i<=packdata[2].nodecount;i++)
	for (j=0;j<=packdata[2].packK_ptr[i].num;j++)
	 {
	   ratio=packdata[2].packR_ptr[i].rad/
		packdata[2].packR_ptr[packdata[2].packK_ptr[i].flower[j]].rad;
	   mr = (ratio > mr) ? ratio : mr;
	 }
	sprintf(msgbuf,"Max ratio of eucl radii of neighbors, p=2, is %lf.",mr);
	msg();
	return 1;
} /* special4 */

int
special5(datastr) /* special routine 5. Mark "p1 p2 x". This reduces bdry
angle sums of p2 by x times the corresponding bdry angle sum in
p1. No angle sum of p2 is reduced below .0001; negative ones remain
unchanged; minimal error detection. */
char *datastr;
{
	int i,p1,p2;
	float x,newaim,dec;

	if (sscanf(datastr,"%d %d %lf",&p1,&p2,&x) 
		&& p1>=0 && p1<NUM_PACKS && p2>=0 && p2<NUM_PACKS &&
		packdata[p1].status && packdata[p2].status &&
		packdata[p1].nodecount==packdata[p2].nodecount &&
		(-.5<x) && (x<.5))
	 {
		for (i=1;i<=packdata[p2].nodecount;i++)
		 {
			if (packdata[p2].packK_ptr[i].bdry_flag)
			 {
			   dec=fabs(packdata[p1].packR_ptr[i].aim)*x;
			   newaim=(fabs(packdata[p2].packR_ptr[i].aim))-dec;
			   if (newaim>0.0001) 
				   packdata[p2].packR_ptr[i].aim=newaim;
			   else packdata[p2].packR_ptr[i].aim=.0001;
			 }
		 }
	 }
	else
	 {
		strcpy(msgbuf,"Usage: special5 p q x.  Decr bdry angles of q by x times those of p.  ");
		emsg();
		return 0;
	 }
	return 1;
} /* special5 */
 
int
special6(datastr) 
char *datastr;
{
	int pnum,i,count=0;
	float min_dist,xx,yy,factor=.3333;

/* must read in number of pack */

	if (sscanf(datastr,"%d %lf",&pnum,&factor) && pnum>=0 
		&& pnum<NUM_PACKS && packdata[pnum].status 
		&& packdata[pnum].hes==0 && factor>.01
		&& factor < 1.0)
	 {
/* scan vertices */
	   for (i=1;i<=packdata[pnum].nodecount;i++) 
	    {
/* pick out boundary ones */
		if (packdata[pnum].packK_ptr[i].bdry_flag) 
		 {
			xx=packdata[pnum].packR_ptr[i].center.re;
			yy=packdata[pnum].packR_ptr[i].center.im;
/* min_dist has minimum distance to unit square */
			min_dist=fabs(1-xx);
			if (fabs(xx+1)<min_dist) min_dist=fabs(xx+1);
			if (fabs(1-yy)<min_dist) min_dist=fabs(1-yy);
			if (fabs(yy+1)<min_dist) min_dist=fabs(yy+1);
/* adjust, but don't cut down by too much */
			if (min_dist<(packdata[pnum].packR_ptr[i].rad)*factor)
			 {
				packdata[pnum].packR_ptr[i].rad=
					packdata[pnum].packR_ptr[i].rad*factor;
				count++;
			 }
			else if (min_dist<packdata[pnum].packR_ptr[i].rad)
			 {
				packdata[pnum].packR_ptr[i].rad=min_dist;
				count++;
			 }
		 }
	    }
	   if (count) fillcurves(&packdata[pnum]);
	 }
	else /* if there was some problem, e.g., pack wasn't given */
	 {
		sprintf(msgbuf,"Special6 error. Is pack euclidean?");
		emsg();
		return 0;
	 }
/* return shows if any changes were made */
	return count; 
} /* special6 */


int
special7(datastr) 
char *datastr;
{
	int pnum,i,count=0,sideflag;
	float min_dist,xx,yy,factor=.3333,rad;

/* must read in number of pack */

	if (sscanf(datastr,"%d %lf",&pnum,&factor) && pnum>=0 
		&& pnum<NUM_PACKS && packdata[pnum].status 
		&& packdata[pnum].hes==0 && factor>.01
		&& factor < 1.0)
	 {
/* scan vertices */
	   for (i=1;i<=packdata[pnum].nodecount;i++) 
	    {
/* pick out boundary ones */
		if (packdata[pnum].packK_ptr[i].bdry_flag) 
		 {
			sideflag=1;
			xx=packdata[pnum].packR_ptr[i].center.re;
			yy=packdata[pnum].packR_ptr[i].center.im;
			rad=packdata[pnum].packR_ptr[i].rad;
			if ((xx+rad)>1.0 || (xx-rad)<-1.0 
				|| (yy+rad)>1.0 || (yy-rad)<-1.0) sideflag=0;
/* min_dist has minimum distance to unit square */
			min_dist=fabs(1-xx);
			if (fabs(xx+1)<min_dist) min_dist=fabs(xx+1);
			if (fabs(1-yy)<min_dist) min_dist=fabs(1-yy);
			if (fabs(yy+1)<min_dist) min_dist=fabs(yy+1);
/* adjust, but don't move down or up too much */
			if (min_dist<(packdata[pnum].packR_ptr[i].rad)*factor
			   || min_dist>(packdata[pnum].packR_ptr[i].rad)/factor)
			 {
			   if (!sideflag)
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*(1.0+ 
					factor)/2.0;
				count++;
			    }
			   else
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +1.0/factor)/2.0;
				count++;
			    }

			 }
			else if (min_dist > packdata[pnum].packR_ptr[i].rad 
			   && !sideflag)
			 {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +factor)/2.0;
				count ++;
			 }
			else			
			 {
			  	packdata[pnum].packR_ptr[i].rad=
				   (packdata[pnum].packR_ptr[i].rad+
					min_dist)/2.0;
				count++;
			 }
		 }
	    }
	   if (count) fillcurves(&packdata[pnum]);
	 }
	else /* if there was some problem, e.g., pack wasn't given */
	 {
		sprintf(msgbuf,"Special7 error. Is pack euclidean?");
		emsg();
		return 0;
	 }
/* return shows if any changes were made */
	return count; 
} /* special7 */

int
special8(datastr) 
char *datastr;
{
	int pnum,i,count=0,sideflag;
	float min_dist,xx,factor=.3333,rad;

/* must read in number of pack */

	if (sscanf(datastr,"%d %lf",&pnum,&factor) && pnum>=0 
		&& pnum<NUM_PACKS && packdata[pnum].status 
		&& packdata[pnum].hes==0 && factor>.01
		&& factor < 1.0)
	 {
/* scan vertices */
	   for (i=1;i<=packdata[pnum].nodecount;i++) 
	    {
/* pick out boundary ones */
		if (packdata[pnum].packK_ptr[i].bdry_flag) 
		 {
			sideflag=1;
			xx=packdata[pnum].packR_ptr[i].center.re;
			rad=packdata[pnum].packR_ptr[i].rad;
			if ((xx+rad)>1.0 || (xx-rad)<-1.0 ) sideflag=0;
/* min_dist has minimum distance to unit square */
			min_dist=fabs(1-xx);
			if (fabs(xx+1)<min_dist) min_dist=fabs(xx+1);
/* adjust, but don't move down or up too much */
			if (min_dist<(packdata[pnum].packR_ptr[i].rad)*factor
			   || min_dist>(packdata[pnum].packR_ptr[i].rad)/factor)
			 {
			   if (!sideflag)
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*(1.0 +
					factor)/2.0;
				count++;
			    }
			   else
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +1.0/factor)/2.0;
				count++;
			    }

			 }
			else if (min_dist > packdata[pnum].packR_ptr[i].rad 
			   && !sideflag)
			 {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +factor)/2.0;
				count ++;
			 }
			else			
			 {
			  	packdata[pnum].packR_ptr[i].rad=
				   (packdata[pnum].packR_ptr[i].rad+
					min_dist)/2.0;
				count++;
			 }
		 }
	    }
	   if (count) fillcurves(&packdata[pnum]);
	 }
	else /* if there was some problem, e.g., pack wasn't given */
	 {
		sprintf(msgbuf,"Special8 error. Is pack euclidean?");
		emsg();
		return 0;
	 }
/* return shows if any changes were made */
	return count; 
} /* special8 */




