#include "cp_types.h"
#include "cp_proto.h"

/* dist from pt to eucl segment [p1,p2] */

double seg_dist(complex pt,complex p1,complex p2)
{
  double x,y,x1,y1,x2,y2,m;
  complex z,w;

  x=pt.re;y=pt.im;
  x1=p1.re;y1=p1.im;
  x2=p2.re;y2=p2.im;
  if (x1!=x2 && y1!=y2)
    {
      m=(y2-y1)/(x2-x1);
      if (x2<x1)
	{z=p2; p2=p1; p1=z;x1=p1.re;y1=p1.im;x2=p2.re;y2=p2.im;}
      z.re=(x+m*(y-y1+m*x1))/(m*m+1);
      z.im=m*(z.re-x1)+y1;
      if (z.re<x1)
	{
	  w=csub(pt,p1);
	  return (cAbs(w));
	}
      if (z.re>x2)
	{
	  w=csub(pt,p2);
	  return (cAbs(w));
	}
      w=csub(z,pt);
      return (cAbs(w));
    }
  if (x1==x2)
    {
      if (y1==y2)
	{
	  w=csub(pt,p1);
	  return (cAbs(w));
	}
      if (y2<y1) 
	{z=p2; p2=p1; p1=z;x1=p1.re;y1=p1.im;x2=p2.re;y2=p2.im;}
      if (y<y1)
	{
	  w=csub(pt,p1);
	  return (cAbs(w));
	}
      if (y>y2)
	{
	  w=csub(pt,p2);
	  return (cAbs(w));
	}
      return (fabs(x-x1));
    }
  if (x2<x1)
    {z=p2; p2=p1; p1=z;x1=p1.re;y1=p1.im;x2=p2.re;y2=p2.im;}
  if (x<x1)
    {
      w=csub(pt,p1);
      return (cAbs(w));
    }
  if (x>x2)
    {
      w=csub(pt,p2);
      return (cAbs(w));
    }
  return (fabs(y-y1));
} /* seg_dist */
