#include "cp_types.h"
#include "cp_proto.h"

/* set radii for verts of string  */

int set_radii(struct p_data *p,double rad,char *datastr)
{
  int count=0,hits;
  double orad;
  char *endptr;
  struct Vertlist *vertlist,*trace;
	
  orad=rad;
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
		 &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) != NULL)
    {
      trace=vertlist;
      if (p->hes<0)
	{
	  if (rad>0) rad=exp(-rad); /* convert rad */
	  do {
	    count += h_changerad(p,trace->v,rad);
	    trace=trace->next;
	  } while (trace!=NULL);
	}
      else if (p->hes==0)
	{
	  do {
	    count += e_changerad(p,trace->v,rad);
	    trace=trace->next;
	  } while (trace!=NULL);
	}
      else if (p->hes>0)
	{
	  do {
	    p->packR_ptr[trace->v].rad=rad;
	    trace=trace->next;
	    count++;
	  } while (trace!=NULL);
	}
      vert_free(&vertlist);
    }
  if (count)
    {
      fillcurves(p);
      sprintf(msgbuf,"Set %d radii of pack to %f.",
	      count,orad);
      msg();
      return count;
    }
  strcpy(msgbuf,"No radii adjusted.");
  emsg();
  return 0;
} /* set_radii */
