;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;; $Id: echo.lisp,v 1.1 2001/06/19 15:50:04 lyn Exp $

;; Copyright (C) 1999, 2000 onShore Inc.
;; See the file 'COPYING' in this directory for terms.

;; This example echoes whatever the user types in the text area

(in-package :imho)

(defclass echoer (html-form) ())

(defbindings echoer
    ((area
      :type text-area)
     (submit
      :initargs (:value "echo")
      :type submit-button)))

(defmethod render-html ((element echoer) stream)
  (with-element-values (area)
    element
    (write-string area stream))
  (render-child element :area stream)
  (render-child element :submit stream))

(define-wm echo ((element echoer))
  element) ; nil would also work

(defapplication echo-app
  :base-url "echo-app"
  :initial-element echoer)

(init/application 'echo-app :start)
