(in-package :conditions)

(defun error (datum &rest arguments)
  "Invokes the signal facility on a condition formed from datum and arguments.
   If the condition is not handled, the debugger is invoked."
  (kernel:infinite-error-protect
    (let ((condition (coerce-to-condition datum arguments
					  'simple-error 'error))
	  (debug:*stack-top-hint* debug:*stack-top-hint*))
      (unless (and (condition-function-name condition) debug:*stack-top-hint*)
	(multiple-value-bind
	    (name frame)
	    (kernel:find-caller-name)
	  (unless (condition-function-name condition)
	    (setf (condition-function-name condition) name))
	  (unless debug:*stack-top-hint*
	    (setf debug:*stack-top-hint* frame))))
      (cl-user::barf-stack)
      (let ((debug:*stack-top-hint* nil))
	(signal condition))
      (invoke-debugger condition))))



(in-package :pcl)

(defmethod no-applicable-method (generic-function &rest args)
  (error "No matching method for the generic-function ~S,~@
          when called with arguments ~S."
         generic-function args))