(in-package :cl-user)

(use-package :net.html.generator)

(defvar *barf* t)
(defvar *barfing* nil)
(defvar *last-barf* nil)

(defun barf-stack ()
  (when (and *barf* (not *barfing*))
    (progv '(*barfing*)
        (list t)
      (let ((barf-stream (make-string-output-stream)))
        (do ((frame (di:top-frame) (di:frame-down frame)))
            ((null frame))
          (html-stream
           barf-stream
           ((:table :cellspacing 0 :cellpadding 0 :border 0 :width 800 :bgcolor "#000000")
            (:tr
             ((:td :width "100%")
              (barf-frame frame barf-stream))))
           (:br)))
        (setf *last-barf* (get-output-stream-string barf-stream))))))

;;;; Frame printing:

(eval-when (compile eval)

;;; LAMBDA-LIST-ELEMENT-DISPATCH -- Internal.
;;;
;;; This is a convenient way to express what to do for each type of lambda-list
;;; element.
;;;
(defmacro lambda-list-element-dispatch (element &key required optional rest
						keyword deleted)
  `(etypecase ,element
     (di:debug-variable
      ,@required)
     (cons
      (ecase (car ,element)
	(:optional ,@optional)
	(:rest ,@rest)
	(:keyword ,@keyword)))
     (symbol
      (assert (eq ,element :deleted))
      ,@deleted)))

(defmacro lambda-var-dispatch (variable location deleted valid other)
  (let ((var (gensym)))
    `(let ((,var ,variable))
       (cond ((eq ,var :deleted) ,deleted)
	     ((eq (di:debug-variable-validity ,var ,location) :valid) ,valid)
	     (t ,other)))))

) ;EVAL-WHEN



(defun barf-frame-1 (frame stream)
  (let* ((d-fun (di:frame-debug-function frame))
	 (loc (di:frame-code-location frame))
	 (results (list (di:debug-function-name d-fun))))
    (handler-case
	(dolist (ele (di:debug-function-lambda-list d-fun))
	  (lambda-list-element-dispatch ele
	    :required ((push (frame-call-arg ele loc frame) results))
	    :optional ((push (frame-call-arg (second ele) loc frame) results))
	    :keyword ((push (second ele) results)
		      (push (frame-call-arg (third ele) loc frame) results))
	    :deleted ((push (frame-call-arg ele loc frame) results))
	    :rest ((lambda-var-dispatch (second ele) loc
		     nil
		     (progn
		       (setf results
			     (append (reverse (di:debug-variable-value
					       (second ele) frame))
				     results))
		       (return))
		     (push (debug::make-unprintable-object "unavaliable-rest-arg")
			   results)))))
      (di:lambda-list-unavailable
       ()
       (push (debug::make-unprintable-object "lambda-list-unavailable") results)))
    (print-code-block (prin1-to-string (mapcar #'ensure-printable-object (nreverse results)))
                      stream)
    (when (di:debug-function-kind d-fun)
      (write-char #\[ stream)
      (prin1 (di:debug-function-kind d-fun) stream)
      (write-char #\] stream))))

(defun ensure-printable-object (object)
  (handler-case
      (with-open-stream (out (make-broadcast-stream))
	(prin1 object out)
	object)
    (error (cond)
      (declare (ignore cond))
      (debug::make-unprintable-object "error printing object"))))

(defun frame-call-arg (var location frame)
  (lambda-var-dispatch var location
    (debug::make-unprintable-object "unused-arg")
    (di:debug-variable-value var frame)
    (debug::make-unprintable-object "unavailable-arg")))

(defun print-code-block (string stream)
  (let ((lines (odcl:split string #\Newline)))
    (dolist (line lines)
      (do ((i 0 (incf i)))
          ((or (= i (length line))
               (char/= (aref line i) #\Space))
           (let ((tag-pos (search "#:***HERE***" line)))
             (if tag-pos
                 (html-stream
                  stream
                  ((:font :face "Arial,Helvetica,sans-serif" :size "-2")
                   (:princ-safe (subseq line i tag-pos))
                   ((:font :color :red)
                    (:blink
                     (:princ-safe "===>>")))
                   (:princ-safe (subseq line (+ 12 tag-pos)))
                   (:br)))
                 (html-stream
                  stream
                  ((:font :face "Arial,Helvetica,sans-serif" :size "-2")
                   (:princ-safe (subseq line i))
                   (:br))))))
        (write-string "&nbsp;" stream)))))

(defun print-code-location-source-form (location context stream)
  (let* ((location (debug::maybe-block-start-location location))
	 (form-num (di:code-location-form-number location)))
    (multiple-value-bind (translations form)
        (debug::get-top-level-form location)
      (unless (< form-num (length translations))
	(error "Source path no longer exists."))
      (print-code-block (prin1-to-string (di:source-path-context form (svref translations form-num) context))
                        stream))))

(defun barf-frame (frame stream)
  (html-stream
   stream
   ((:table :bgcolor "#eeeeff" :border 0 :cellpadding 4 :cellspacing 1 :width "100%")
    (:tr
     ((:td :width "16%" :bgcolor "#ff7777")
      ((:font :face "Arial,Helvetica,sans-serif")
       (format stream "&nbsp;Frame #~S" (di:frame-number frame))))
     ((:td :width "84%")
      (barf-frame-1 frame stream)))
    (let ((loc (di:frame-code-location frame)))
      (handler-case
          (progn
            (di:code-location-debug-block loc)
            (html-stream
             stream
             (:tr
              ((:td :colspan 2)
               (print-code-location-source-form loc 2 stream)))))
        (di:debug-condition ()
          )
        (error ()
          )))
    (:tr
     ((:td :colspan 2 :bgcolor "#6666ff")
      (:princ "Local Variables:")
      ))
    (let ((d-fun (di:frame-debug-function frame)))
      (if (di:debug-variable-info-available d-fun)
          (let ((location (di:frame-code-location frame))
                (any-p nil)
                (any-valid-p nil))
            (html-stream
             stream
             (:tr
              ((:td :colspan 2)
               ((:table :width "100%" :border 0 :cellspacing 0 :cellpadding 4)
                (dolist (v (di:ambiguous-debug-variables d-fun ""))
                  (setf any-p t)
                  (when (eq (di:debug-variable-validity v location) :valid)
                    (setf any-valid-p t)
                    (html-stream
                     stream
                     (:tr
                      ((:td :width "25%" :bgcolor "#9999ff")
                       (:princ-safe (format nil "~S~:[#~D~;~*~]"
                                            (di:debug-variable-symbol v)
                                            (zerop (di:debug-variable-id v))
                                            (di:debug-variable-id v))))
                      ((:td :bgcolor "#aaaaff")
                       (:princ-safe (format nil "~S" (di:debug-variable-value v frame))))))))))))
            (cond
              ((not any-p)
               (html-stream
                stream
                (:tr
                 ((:td :colspan 2)
                  (format stream "No local variables in function.")))))
              ((not any-valid-p)
               (html-stream
                stream
                (:tr
                 ((:td :colspan 2)
                  (format stream "All variables currently have invalid values.")))))))
          (html-stream
           stream
           (:tr
            ((:td :colspan 2)
             (:princ "No variable information available.")))))))))



