
#include "image.h"

static lisp_image *active_lisps;

void image_init()
{
  active_lisps = NULL;
}

void image_terminate()
{
  lisp_image *image = active_lisps;

  while (image != NULL)
    {
      kill(image->pid, 9);
      image = image->next;
    }
}

/* Return non-zero if an image by the given name exists.
 */

lisp_image *image_for_name(const char *image_name)
{
  lisp_image *image = active_lisps;

  while (image != NULL)
    {
      if (!strcmp(image->name, image_name))
        {
          return image;
        }
      image = image->next;
    }
  return NULL;
}

lisp_image *image_create(const char *image_name)
{
  int pid;
  lisp_image *new_image, *image;

  if (image_for_name(image_name))
    {
      printf("image '%s' already exists\n");
      return (lisp_image *) -1;
    }

  new_image = (lisp_image *) malloc(sizeof(lisp_image));
  new_image->name = (char *) malloc(strlen(image_name));
  strcpy(new_image->name, image_name);
  pipe(new_image->filedes);

  pid = fork();

  if (pid < 0)
    {
      perror("forking lisp image");
    }
  else if (pid == 0)
    {
      if (dup2 (new_image->filedes[0], 0) < 0)
        perror("cannot redirect stdin");
      if (new_image->filedes[0] > 0)
        close (new_image->filedes[0]);

      if (dup2 (new_image->filedes[1], 1) < 0)
        perror("cannot redirect stdout");
      if (new_image->filedes[1] == 0 || new_image->filedes[1] > 1)
        close (new_image->filedes[1]);

      exit (execve (LISP_PATH, NULL, NULL));
    }
  else
    {
      // link the child to the global image list
      new_image->pid = pid;
      new_image->next = active_lisps;
      active_lisps = new_image;
      return 0;
    }
}


int image_destroy(const char *image_name)
{
  int pid, cmd_rtn;
  lisp_image *new_image, *image;

  // check to see that the requested image doesn't already exist.

  image = active_lisps;
  while (image != NULL)
    {
      if (!strcmp(image->name, image_name))
        {
          if ((cmd_rtn = kill(image->pid, 9)) == -1)
            {
              perror("killing lisp");
              return -1;
            }
          else
            {
              printf("image '%s' killed\n", image_name);
              return 0;
            }
        }
      image = image->next;
    }

  printf("image '%s' not found\n");
  return -1;
}

