/*
 *
 */

#ifndef _LCTL_H
#define _LCTL_H

#include <stdio.h>

#define LISP_PATH "/usr/bin/lisp"
#define LISP_PROJ 0


enum lctl_actions {
  SVC_START,
  SVC_STOP,
  SVC_CREATE,
  SVC_CONNECT,
  SVC_TEST,
};

typedef struct action {
  char *name;
  int number;
} paction;

static paction commands[] = {
  {"start", SVC_START},
  {"stop", SVC_STOP},
  {"create", SVC_CREATE},
  {"connect", SVC_CONNECT},
  {"test", SVC_TEST},
  NULL
};

typedef struct _lisp_image lisp_image;

struct _lisp_image {
  lisp_image *next;
  char *name;
  int pid;
  int filedes[2];
};

#define LCTL_MSGLEN 1024
#define LCTL_TEXTLEN (LCTL_MSGLEN - (2 * sizeof(unsigned long)))

/* The server:
 *
 * grants tickets on channel 1
 * receives reponses on channel 2
 * 
 * The client:
 *
 * receives responses on the ticket channel
 */
typedef struct _lctl_msg {
  long channel;
  long ticket;
  long code;
  char text[LCTL_TEXTLEN];
} lctl_msg;

enum lctl_msgs {
  SUCCESS,
  FAILURE,
  SRV_STOP,
  IMG_CREATE,
  IMG_DESTROY,
  IMG_SEND,
};



#endif /* _LCTL_H */
