;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: streams.lisp,v 1.5 2001/11/12 20:07:08 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)
#+cmu

(progn
(defstruct (byte-array-output-stream
             (:include system:lisp-stream
                       (bout #'byte-array-bout)
                       (misc #'byte-array-out-misc))
             (:print-function %print-byte-array-output-stream)
             (:constructor make-byte-array-output-stream ()))
  ;; The buffer we throw stuff in.
  (buffer (make-array 128 :element-type '(unsigned-byte 8)))
  ;; Index of the next location to use.
  (index 0 :type fixnum))

(defun %print-byte-array-output-stream (s stream d)
  (declare (ignore s d))
  (write-string "#<Byte-Array-Output Stream>" stream))

(setf (documentation 'make-binary-output-stream 'function)
  "Returns an Output stream which will accumulate all output given it for
   the benefit of the function Get-Output-Stream-Data.")

(defun byte-array-bout (stream byte)
  (let ((current (byte-array-output-stream-index stream))
	(workspace (byte-array-output-stream-buffer stream)))
    (if (= current (length workspace))
	(let ((new-workspace (make-array (* current 2) :element-type '(unsigned-byte 8))))
	  (replace new-workspace workspace)
	  (setf (aref new-workspace current) byte)
	  (setf (byte-array-output-stream-buffer stream) new-workspace))
	(setf (aref workspace current) byte))
    (setf (byte-array-output-stream-index stream) (1+ current))))

(defun byte-array-out-misc (stream operation &optional arg1 arg2)
  (declare (ignore arg2))
  (case operation
    (:file-position
     (if (null arg1)
	 (byte-array-output-stream-index stream)))
    (:element-type '(unsigned-byte 8))))

(defun get-output-stream-data (stream)
  "Returns an array of all data sent to a stream made by
Make-Byte-Array-Output-Stream since the last call to this function."
  (declare (type byte-array-output-stream stream))
  (let* ((length (byte-array-output-stream-index stream))
	 (result (make-array length :element-type '(unsigned-byte 8))))
    (replace result (byte-array-output-stream-buffer stream))
    (setf (byte-array-output-stream-index stream) 0)
    result))

(defun dump-output-stream-data (stream)
  "Returns an array of all data sent to a stream made by
Make-Byte-Array-Output-Stream since the last call to this function."
  (declare (type byte-array-output-stream stream))
  (let* ((length (byte-array-output-stream-index stream))
	 (result (make-array length :element-type '(unsigned-byte 8))))
    (replace result (byte-array-output-stream-buffer stream))
    result))



(defstruct (byte-array-input-stream
	     (:include system:lisp-stream
		       (in #'byte-array-inch)
		       (bin #'byte-array-binch)
		       (n-bin #'byte-array-stream-read-n-bytes)
		       (misc #'byte-array-in-misc))
	     (:print-function %print-byte-array-input-stream)
					;(:constructor nil)
	     (:constructor internal-make-byte-array-input-stream
			   (byte-array current end)))
  (byte-array nil :type vector)
  (current nil)
  (end nil))

(defun %print-byte-array-input-stream (s stream d)
  (declare (ignore s d))
  (write-string "#<Byte-Array-Input Stream>" stream))
  
(defun byte-array-inch (stream eof-errorp eof-value)
  (let ((byte-array (byte-array-input-stream-byte-array stream))
	(index (byte-array-input-stream-current stream)))
    (cond ((= index (byte-array-input-stream-end stream))
	   (common-lisp::eof-or-lose stream eof-errorp eof-value))
	  (t
	   (setf (byte-array-input-stream-current stream) (1+ index))
	   (aref byte-array index)))))

(defun byte-array-binch (stream eof-errorp eof-value)
  (let ((byte-array (byte-array-input-stream-byte-array stream))
	(index (byte-array-input-stream-current stream)))
    (cond ((= index (byte-array-input-stream-end stream))
	   (common-lisp::eof-or-lose stream eof-errorp eof-value))
	  (t
	   (setf (byte-array-input-stream-current stream) (1+ index))
	   (aref byte-array index)))))

(defun byte-array-stream-read-n-bytes (stream buffer start requested eof-errorp)
  (declare (type byte-array-input-stream stream))
  (let* ((byte-array (byte-array-input-stream-byte-array stream))
	 (index (byte-array-input-stream-current stream))
	 (available (- (byte-array-input-stream-end stream) index))
	 (copy (min available requested)))
    (when (plusp copy)
      (setf (byte-array-input-stream-current stream)
	    (+ index copy))
      (system:without-gcing
       (system::system-area-copy (system:vector-sap byte-array)
			 (* index vm:byte-bits)
			 (if (typep buffer 'system::system-area-pointer)
			     buffer
			     (system:vector-sap buffer))
			 (* start vm:byte-bits)
			 (* copy vm:byte-bits))))
    (if (and (> requested copy) eof-errorp)
	(error 'end-of-file :stream stream)
	copy)))

(defun byte-array-in-misc (stream operation &optional arg1 arg2)
  (declare (ignore arg2))
  (case operation
    (:file-position
     (if arg1
	 (setf (byte-array-input-stream-current stream) arg1)
	 (byte-array-input-stream-current stream)))
    (:file-length (length (byte-array-input-stream-byte-array stream)))
    (:unread (decf (byte-array-input-stream-current stream)))
    (:listen (or (/= (the fixnum (byte-array-input-stream-current stream))
		     (the fixnum (byte-array-input-stream-end stream)))
		 :eof))
    (:element-type 'base-char)))
  
(defun make-byte-array-input-stream (buffer &optional (start 0) (end (length buffer)))
  "Returns an input stream which will supply the bytes of BUFFER between
  Start and End in order."
  (internal-make-byte-array-input-stream buffer start end))

)                                       ; progn