
(use-package :gl)
(require 'pnm)

(defvar *image* nil)
(defvar window)

(defvar display-callback)
(ff:defun-c-callable display ()
 (format t "Redrawing~%")
 (glClear GL_COLOR_BUFFER_BIT)
 (glRasterPos2i 0 0)
 ;; Put image up.  PGM is array of Gray bytes; PPM is array of RGB bytes.
 (if (pnm:pgm? *image*)
     (glDrawPixels (pnm:pgm-width *image*) (pnm:pgm-height *image*) 
		   GL_LUMINANCE GL_UNSIGNED_BYTE 
		   (pnm:pgm-xels *image*))
     (glDrawPixels (pnm:ppm-width *image*) (pnm:ppm-height *image*) 
		   GL_RGB GL_UNSIGNED_BYTE 
		   (pnm:ppm-xels *image*)))
 (glutswapbuffers))
(setq display-callback (ff:register-function 'display))

;;; Always keeps 2d geometry fullsize in window
;;; Does not seem to work for images?
(defvar reshape-callback)
(ff:defun-c-callable reshape ((width :fixnum) (height :fixnum))
 (format t "Resizing~%")
 (glviewport 0 0 width height)
 (glmatrixmode GL_PROJECTION)
 (glloadidentity)
 (glortho 0d0 (coerce (pnm:pgm-width *image*) 'double-float)
	  0d0 (coerce (pnm:pgm-height *image*) 'double-float) -1d0 1d0)
 (glmatrixmode GL_MODELVIEW))
(setq reshape-callback (ff:register-function 'reshape))

(defun main ()
 (format t "GLIMAGE.~%")
 ;;
 (format t "Input image name:")
 (let* ((pathname (read-line *standard-input*))
	(color? nil)
	(width nil)
	(height nil))
  (setq *image* (pnm:read-pnm pathname)))
 (cond ((pnm:ppm? *image*)
	(setq color? t)
	(setq width (pnm:ppm-width *image*))
	(setq height (pnm:ppm-height *image*))
	(pnm:ppm-flip! *image*))
       ((pnm:pgm? *image*)
	(setq color? nil)
	(setq width (pnm:pgm-width *image*))
	(setq height (pnm:pgm-height *image*))
	(pnm:pgm-flip! *image*)))
 ;;
 (glutInitDisplayMode (+ GLUT_RGB GLUT_DOUBLE))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize width height)
 (setq window (glutCreateWindow "glimage-glut"))
 ;;
 (glClearIndex 0.0)
 (glShadeModel GL_FLAT)
 (glclearcolor 0.0 0.0 0.0 1.0)
 ;;
 (glutDisplayFunc display-callback)
 (glutReshapeFunc reshape-callback)
 ;;
 (glutMainLoop))
