
(eval-when (:compile-toplevel :load-toplevel)
  (require :gl))

(defun glut-program (&key
		     (title "GLUT window")
		     (width 100) (height 100)
		     (x-pos 0) (y-pos 0)
		     (exit-tag :exit-glut)
		     displayfunc reshapefunc keyboardfunc mousefunc
		     motionfunc passivemotionfunc entryfunc
		     visibilityfunc idlefunc menustatefunc
		     specialfunc spaceballmotionfunc spaceballrotatefunc
		     spaceballbuttonfunc buttonboxfunc dialsfunc
		     tabletmotionfunc tabletbuttonfunc menustatusfunc
		     overlaydisplayfunc windowstatusfunc)
  "This function runs a GLUT program with the supplied parameters and
callback functions.  This is one possible starting point for a more
Lisp-like interface to OpenGL/GLUT.  To quit the glutMainLoop, use THROW
with the EXIT-TAG parameter, for instance (throw :exit-glut nil)."
  
  (when (null displayfunc)
    (error "You need to supply at least a DISPLAYFUNC callback."))
  (gl:glutInitDisplayMode (+ gl:GLUT_RGB gl:GLUT_DOUBLE))
  (gl:glutInitWindowPosition x-pos y-pos)
  (gl:glutInitWindowSize width height)
  (let ((window (gl:glutCreateWindow title)))
    (macrolet ((set-glut-function (name)
		 (let ((glut-name (find-symbol (concatenate
						'string
						(symbol-name :glut)
						(symbol-name name))
					       :gl)))
		   `(when ,name (,glut-name ,name))))
	       (set-glut-functions (&rest names)
		 `(progn
		   ,@(mapcar (lambda (name) `(set-glut-function ,name))
			     names))))
      (set-glut-functions
       displayfunc reshapefunc keyboardfunc mousefunc
       motionfunc passivemotionfunc entryfunc
       visibilityfunc idlefunc menustatefunc
       specialfunc spaceballmotionfunc spaceballrotatefunc
       spaceballbuttonfunc buttonboxfunc dialsfunc
       tabletmotionfunc tabletbuttonfunc menustatusfunc
       overlaydisplayfunc windowstatusfunc))
    (unwind-protect
	 (catch exit-tag (gl:glutMainLoop))
      (gl:glutDestroyWindow window))))

(defun a-glut-program ()
  (glut-program :title "Rectangle"
		:displayfunc (lambda ()
			       (write-line "display")
			       (gl:glClearColor 1.0 1.0 1.0 1.0)
			       (gl:glClear gl:GL_COLOR_BUFFER_BIT)
			       (gl:glColor3f 0.0 0.0 0.0)
			       (gl:glRectf -0.5 -0.5 0.5 0.5)
			       (gl:glutSwapBuffers))
		:reshapefunc (lambda (w h)
			       (format t "reshape ~A ~A~%" w h)
			       (gl:glViewport 0 0 w h)
			       (gl:glMatrixMode gl:GL_PROJECTION)
			       (gl:glLoadIdentity)
			       (gl:gluOrtho2D -1.0d0 1.0d0 -1.0d0 1.0d0)
			       (gl:glMatrixMode gl:GL_MODELVIEW))
		:mousefunc (lambda (button state x y)
			     (format t "mouse ~A ~A x:~A y:~A~%"
				     (cond
				       ((= button gl:GLUT_LEFT_BUTTON)
					'left)
				       ((= button gl:GLUT_RIGHT_BUTTON)
					'right)
				       ((= button gl:GLUT_MIDDLE_BUTTON)
					'middle))
				     (cond
				       ((= state gl:GLUT_DOWN) 'press)
				       ((= state gl:GLUT_UP) 'release))
				     x y))
		:keyboardfunc (lambda (k x y)
				(format t "keyboard k:~A x:~A y:~A~%"
					(code-char k) x y)
				(when (eql (code-char k) #\g)
				  (format t "Forcing GC...~%")
				  (gc :full t)
				  (format t "...done.~%"))
				(when (eql (code-char k) #\Escape)
				  (throw :exit-glut :bye)))))
