;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: network.lisp,v 1.13 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 1999 - 2003 onShore Development, Inc.

(in-package :odcl)

;; internet address to string

(defun ip-address-string (address)
  (if address
      (format nil "~D.~D.~D.~D"
              (ldb (byte 8 24) address)
              (ldb (byte 8 16) address)
              (ldb (byte 8 8)  address)
              (ldb (byte 8 0)  address))
      "0.0.0.0"))

#+cmu
(defun local-host-name ()
  (let ((output (make-string-output-stream))
        (errors (make-string-output-stream)))
    (ext:run-program "hostname" '("--fqdn")
                     :wait t
                     :error errors
                     :output output)
    (string-trim "
" (get-output-stream-string output))))

;; only CMUCL has make-fd-stream
#+cmu
(defun %http-op (host port path operation headers &key content-fn debug)
  (let ((strm (make-string-output-stream))
        (op (ecase operation
              (:get "GET")
              (:post "POST")))
        lines)
    (format strm "~a ~a HTTP/1.0" op path)
    (crlf strm)
    (push (cons "Host" host) headers)
    (dolist (header headers)
      (format strm "~a: ~a" (car header) (cdr header))
      (crlf strm))
    (if content-fn
        (funcall content-fn strm))
    (crlf strm)
    (let ((packet (get-output-stream-string strm)))
      (when debug (cmsg "Request: ~s" packet))
      (let ((http-stream (system:make-fd-stream (ext:connect-to-inet-socket host port)
                                                :input t :output t :buffering :none)))
        (unwind-protect
             (progn
               (write-string packet http-stream)
               (progn
                 (handler-case (loop (push (read-line http-stream) lines))
                   (end-of-file))
                 (trim-response (apply #'concatenate 'string (nreverse lines)))))
          (close http-stream))))))

#+cmu
(defun http-get (host port path)
  (%http-op host port path :get '(("User-Agent". "common-lisp/0")
                                  ("Accept-Charset" . "iso-8859-1,*,utf-8"))
            :debug nil))

#+disabled
(defun http-post (host port path alist)
  (%http-op host port path :post '(("User-Agent". "common-lisp/0")
                                   ("Accept-Charset" . "iso-8859-1,*,utf-8"))
            :content-fn (lambda (stream)
                          (write-string (compose-multipart/form-data alist) stream))
            :debug nil))
                            
(defun crlf (Stream)
  (write-char #\Return stream)
  (write-char #\Linefeed stream))

(defun trim-response (response)
  (let ((first (position #\Return response)))
    (block trim
      (loop
       (let ((next (position #\Return response :start (+ 1 first))))
         (when (= next (+ 1 first))
           (return-from trim (subseq response (+ 2 first))))
         (setq first next))))))
