(in-package :odcl)

(def-message-type test-message
    ((:datum
      :initform nil)))

(defvar *messages-flipper* nil)

(defclass test-simple-listener (simple-listener)
  ()
  (:default-initargs :events '(test-message)))

(defmethod serve-event ((self test-simple-listener) event)
  (destructuring-bind (event-class &rest event-args)
      event
    (case event-class
      (test-message
       (setf *messages-flipper* (getf event-args :datum))))))

(defregression (:messages 1.1)
    "Basic message passing, no synchronization, no transaction."
  (let* ((sync (make-instance 'test-simple-listener :name 'test-listener)))
    (unwind-protect
         (progn
           (setf *messages-flipper* nil)
           (event-listener-register sync)
           (publish-event 'test-message :datum t)
           (unless *messages-flipper*
             (error "Did not receive message")))
      (setf *messages-flipper* nil)
      (event-listener-deregister sync))))

(defregression (:messages 2)
    "Basic message passing, subscribe/unsubscribe"
  (let* ((sync (make-instance 'test-simple-listener :name 'test-listener)))
    (unwind-protect
         (progn
           (setf *messages-flipper* nil)
           (event-listener-register sync)
           (publish-event 'test-message :datum t)
           (event-listener-deregister sync)
           (unless *messages-flipper*
             (error "Did not receive message"))
           (publish-event 'test-message :datum nil)
           (unless *messages-flipper*
             (error "Got message after unsubscribing.")))
      (setf *messages-flipper* nil)
      (event-listener-deregister sync))))

