;; -*- Mode: Lisp -*-
;;
;; $Id: dbms-loader.lisp,v 1.6 2001/12/26 22:32:35 apharris Exp $

;;
;; Backend loader.
;;

(in-package :sql)

;;
;; Method that will be called when an unloaded database backend is
;; referred to. Try to load based on the type symbol name.
;;
;; FIX: add better error handlers
;;
(defmethod database-name-from-spec (connection-spec (type t))
  (let ((backend-system (format nil "cl-library:uncommonsql;dbms;~a;system.lisp"
				(string-downcase (symbol-name type)))))
    (if (not (probe-file backend-system))
	(error (format nil "Backend '~A' does not exist." type)))
    (load backend-system :verbose nil)
    (database-name-from-spec connection-spec type)))
