;;;; MaiSQL --- Common Lisp Interface Layer to SQL Databases
;;;; This is copyrighted software.  See documentation for terms.
;;;; 
;;;; postgresql.cl --- FFI interface to PostgreSQL on Unix
;;;; 
;;;; Checkout Tag: $Name:  $
;;;; $Id: ffi-cmucl.lisp,v 1.1 2001/01/29 19:22:43 jesse Exp $

(in-package :MAISQL-POSTGRESQL)

;;;; %File Description:
;;;; 
;;;; This file implements as little of the FFI bindings to the
;;;; PostgreSQL client libraries as we could get away with.
;;;; Especially all the PostgreSQL-specific goodies aren't there, and
;;;; we just use void pointers where we can get away with it, which
;;;; thanks to the design of the PostgreSQL client libraries is pretty
;;;; much everywhere, in contrast to the MySQL client libraries for
;;;; example.
;;;; 

;;;; Alien Type definitions

(deftype psql-conn-ptr ()
  `(alien psql-conn))

(deftype psql-result-ptr ()
  `(alien psql-result))

;;; Basic Types

(def-alien-type psql-oid unsigned-int)

(def-alien-type psql-conn-status-type
  (enum enum-conn-status-type
	:connection-ok
	:connection-bad))

(def-alien-type psql-exec-status-type
    (enum enum-exec-status-type
	  :empty-query
	  :command-ok
	  :tuples-ok
	  :copy-out
	  :copy-in
	  :bad-response
	  :nonfatal-error
	  :fatal-error))

(def-alien-type psql-conn (* t))

(def-alien-type psql-result (* t))

(declaim (inline PQsetdbLogin))
(def-alien-routine "PQsetdbLogin" psql-conn
  (pghost c-string :in)
  (pgport c-string :in)
  (pgoptions c-string :in)
  (pgtty c-string :in)
  (dbName c-string :in)
  (login c-string :in)
  (pwd c-string :in))

(declaim (inline PQfinish))
(def-alien-routine "PQfinish" void
  (conn psql-conn :in))

(declaim (inline PQstatus))
(def-alien-routine "PQstatus" psql-conn-status-type
  (conn psql-conn :in))

;; (declaim (inline PQerrorMessage))
(def-alien-routine "PQerrorMessage" c-string
  (conn psql-conn :in))

(declaim (inline PQexec))
(def-alien-routine "PQexec" psql-result
  (conn psql-conn :in)
  (query c-string :in))

(declaim (inline PQresultStatus))
(def-alien-routine "PQresultStatus" psql-exec-status-type
  (res psql-result :in))

(declaim (inline PQntuples))
(def-alien-routine "PQntuples" int
  (res psql-result :in))

(declaim (inline PQnfields))
(def-alien-routine "PQnfields" int
  (res psql-result :in))

(declaim (inline PQfname))
(def-alien-routine "PQfname" c-string
  (res psql-result :in)
  (field-num int :in))

(declaim (inline PQfnumber))
(def-alien-routine "PQfnumber" int
  (res psql-result :in)
  (field-name c-string :in))

(declaim (inline PQftype))
(def-alien-routine "PQftype" psql-oid
  (res psql-result :in)
  (field-num int :in))

(declaim (inline PQfsize))
(def-alien-routine "PQfsize" short
  (res psql-result :in)
  (field-num int :in))

(declaim (inline PQcmdStatus))
(def-alien-routine "PQcmdStatus" c-string
  (res psql-result :in))

(declaim (inline PQoidStatus))
(def-alien-routine "PQoidStatus" c-string
  (res psql-result :in))

(declaim (inline PQcmdTuples))
(def-alien-routine "PQcmdTuples" c-string
  (res psql-result :in))

(declaim (inline PQgetvalue))
(def-alien-routine "PQgetvalue" c-string
  (res psql-result :in)
  (tup-num int :in)
  (field-num int :in))

(declaim (inline PQgetlength))
(def-alien-routine "PQgetlength" int
  (res psql-result :in)
  (tup-num int :in)
  (field-num int :in))

(declaim (inline PQgetisnull))
(def-alien-routine "PQgetisnull" boolean
  (res psql-result :in)
  (tup-num int :in)
  (field-num int :in))

(declaim (inline PQclear))
(def-alien-routine "PQclear" void
  (res psql-result :in))
