(in-package :maisql-sys)

;;
;; Functions for schema manipulation
;;


(defun drop-table (name &key (database *default-database*))
  "Drops TABLE from *default-database*, or if a :database keyword
argument is given, the specified database."
  (let ((expr (format nil "DROP TABLE ~A" (sql-output name database))))
    (execute-command expr :database database)))

(defun list-tables (&key (database *default-database*)
			 (system-tables nil))
  "List all tables i*default-database, or if the :database keyword arg
is given, the specified database.  If the keyword arg :system-tables
is true, then it will not filter out non-user tables.  Table names are
given back as a list of strings."
  (database-list-tables database :system-tables system-tables))

(defun tablep (table &key (database *default-database*))
  (let ((tref (etypecase table
                (string (string-upcase table))
                (sql-ident
                 (sql table))
                (symbol
                 (sql-escape (sql table))))))
    (when (and tref
               (member tref (mapcar #'string-upcase
                                    (list-tables :database database :system-tables t))
                       :test #'equal))
      t)))


(defun list-attributes (table &key (database *default-database*))
  "List the attributes of TABLE in *default-database, or if the
:database keyword is given, the specified database.  Attributes are
returned as a list of strings."
  (database-list-attributes table database))

(defun attribute-type (attribute table &key (database *default-database*))
  "Return the field type of the ATTRIBUTE in TABLE.  The optional
keyword argument :database specifies the database to query, defaulting
to *default-database*."
  (database-attribute-type attribute table database))

(defun add-attribute (table attribute &key (database *default-database*))
  "Add the ATTRIBUTE to TABLE.  The ATTRIBUTE sepcification must
include a type argument.  The optional keyword argument :database
specifies the database to operation on, defaulting to
*default-database*."
  (database-add-attribute table attribute database))

(defun rename-attribute (table oldatt newname
			       &key (database *default-database*))
  (error "(rename-attribute ~a ~a ~a ~a) is not implemented" table oldatt newname database))
