#include <iostream.h>
#include <ClanLib/core.h>
#include <ClanLib/gui.h>
#include <ClanLib/application.h>
#include <ClanLib/display.h>

class ListboxTest : public CL_ClanApplication
{
public:
	char *get_title() { return "ListboxTest"; }


	CL_ResourceManager *resources;
	CL_StyleManager_Default *style;
	CL_ComponentManager *manager;
	CL_GUIManager *gui;
	
	int main(int argc, char** argv)
	{
		// Create a console window for text-output if not available
		CL_ConsoleWindow console("Console");
		console.redirect_stdio();

		try
		{
			CL_SetupCore::init();
			CL_SetupGUI::init();
			CL_SetupDisplay::init();
			CL_Display::set_videomode(640,480,16, false, false, false);

			resources = new CL_ResourceManager("resources.scr", false);
			style = new CL_StyleManager_Default(resources);
//			style->set_background_mode(false);
//			style->set_background_texture("background");
			gui = new CL_GUIManager(style);
			manager = CL_ComponentManager::create("listboxtest.gui", false, style,gui);
			
			
			while (!CL_Keyboard::get_keycode(CL_KEY_ESCAPE))
			{
				CL_Display::clear_display(0.0f, 0.0f, 0.0f);
				gui->show();
				CL_System::keep_alive();
				CL_Display::flip_display();
			}
			
			delete gui;
			delete manager;
			delete style;
			delete resources;
			CL_SetupGUI::deinit();
			CL_SetupCore::deinit();
		}
		catch (CL_Error e)
		{
			std::cout << e.message.c_str() << std::endl;
		}
/*		catch (...)
		{
			std::cout << "Ugga" << std::endl;
		}
*/
		// Display console close message and wait for a key
		console.display_close_message();

		return 0;
	}
} app;