%define name clanlib0.5
%define version	0.5.4
%define release 1mdk
%define prefix %{_prefix}
%define lib_name_orig libclanlib
%define lib_major 1
%define lib_name %{lib_name_orig}%{lib_major}

Name: %{name}
Summary: The ClanLib Game SDK
Version: %{version}
Release: %{release}
License: LGPL
Group: System/Libraries
Source: http://dark.x.dtu.dk/~mbn/clanlib/download/download-sphair/ClanLib-%{version}.tar.bz2
URL: http://clanlib.org/
Packager: Jeroen Janssen <japj@clanlib.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: libhermes-devel >= 1.3.0 libmikmod-devel libpng-devel Mesa-common-devel bzip2 libjpeg-devel libtiff-devel XFree86-static-libs libbzip2-devel libvorbis-devel libogg-devel freetype2-devel
BuildConflicts:	OpenPTC-devel
%ifarch %{ix86}
BuildRequires: svgalib-devel
%endif
Obsoletes: ClanLib
Provides: ClanLib = %{version}-%{release}

%description
The ClanLib Game SDK is a crossplatform game library designed to ease the work
for game developers. The goal is to provide a common interface to classical
game problems (loading graphics eg.), so games can share as much code as
possible. Ideally anyone with small resources should be able to write
commercial quality games.

%package -n %{lib_name}
Summary: Main library for %{name}
Group: System/Libraries

%description -n %{lib_name}
This package contains the library needed to run programs dynamically
linked with %{name}.

%package -n %{lib_name}-devel
Summary: Headers for developing programs that will use %{name}
Group: Development/C++
Requires: %{lib_name} = %{version}
Provides: %{lib_name_orig}-devel = %{version}-%{release}
Obsoletes: ClanLib-devel clanlib-devel
Provides: ClanLib-devel = %{version}-%{release} clanlib-devel = %{version}-%{release}

%description -n %{lib_name}-devel
This package contains the headers that programmers will need to develop
applications which will use %{name}.


%package -n %{lib_name}-gl
Summary: ClanLib OpenGL module
Group: System/Libraries
Requires: %{lib_name} = %{version} Mesa
BuildRequires: Mesa-common-devel

%description -n %{lib_name}-gl
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the OpenGL module (clanGL).


%package -n %{lib_name}-sound
Summary: ClanLib Sound module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-sound
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Sound module (clanSound).

%package -n %{lib_name}-vorbis
Summary: ClanLib Vorbis module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-vorbis
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Vorbis module (clanVorbis).

%package -n %{lib_name}-network
Summary: ClanLib Network module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-network
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Network module (clanNetwork).

%package -n %{lib_name}-jpeg
Summary: ClanLib Jpeg module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-jpeg
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Jpeg module (clanJPEG).

%package -n %{lib_name}-gui
Summary: ClanLib Gui module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-gui
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Gui module (clanGUI).

%package -n %{lib_name}-ttf
Summary: ClanLib TTF module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-ttf
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the TTF module (clanTTF).

%package -n %{lib_name}-smalljpeg
Summary: ClanLib SmallJPEG module
Group: System/Libraries
Requires: %{lib_name} = %{version}

%description -n %{lib_name}-smalljpeg
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the SmallJPEG module
(clanSmallJPEG).

%package -n %{lib_name}-mikmod
Summary: ClanLib MikMod module
Group: System/Libraries
Requires: %{lib_name} = %{version}
Obsoletes: ClanLib-mikmod clanlib-mikmod
Provides: ClanLib-mikmod = %{version}-%{release} clanlib-mikmod = %{version}-%{release}

%description -n %{lib_name}-mikmod
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the MikMod module (clanMikMod).

%package -n %{lib_name}-png
Summary: ClanLib PNG module
Group: System/Libraries
Requires: %{lib_name} = %{version}
Obsoletes: ClanLib-png clanlib-png
Provides: ClanLib-png = %{version}-%{release} clanlib-png = %{version}-%{release}

%description -n %{lib_name}-png
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the PNG module (clanPNG).

%package docs
Summary: ClanLib documentation
Group: System/Libraries
Obsoletes: ClanLib-docs clanlib-docs
Provides: ClanLib-docs = %{version}-%{release} clanlib-docs = %{version}-%{release}

%description docs
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package contains the documentation.

%prep
%setup -q -n ClanLib-%{version}

%build
# (sb) doesn't build on PPC with this
%ifnarch ppc
# (gc) workaround g++ exception bug when -fomit-frame-pointer is set
export CFLAGS="$RPM_OPT_FLAGS -fno-omit-frame-pointer" CXXFLAGS="$RPM_OPT_FLAGS -fno-omit-frame-pointer"
%endif
autoconf
%ifarch %{ix86}
  %configure --enable-dyn
%else
  # (sb) configure macro breaks PPC build - just do it manually for now
  %ifnarch ppc
    %configure --enable-dyn --disable-asm386
  %else
    libtoolize --copy --force
    ./configure --enable-dyn --disable-asm386  
  %endif
%endif
make all
make strip
make docs

%install
%makeinstall BIN_PREFIX=$RPM_BUILD_ROOT%{_bindir} LIB_PREFIX=$RPM_BUILD_ROOT%{_libdir} INC_PREFIX=$RPM_BUILD_ROOT%{_includedir} TARGET_PREFIX=$RPM_BUILD_ROOT%{_libdir}/ClanLib
make MAN_PREFIX=$RPM_BUILD_ROOT%{_mandir} HTML_PREFIX=$RPM_BUILD_ROOT%{_datadir}/doc/%{name}-docs-%{version}/Docs docs_install

%post -n %{lib_name} -p /sbin/ldconfig
%post -n %{lib_name}-gl -p /sbin/ldconfig
%post -n %{lib_name}-mikmod -p /sbin/ldconfig
%post -n %{lib_name}-png -p /sbin/ldconfig
%post -n %{lib_name}-sound -p /sbin/ldconfig
%post -n %{lib_name}-vorbis -p /sbin/ldconfig
%post -n %{lib_name}-network -p /sbin/ldconfig
%post -n %{lib_name}-jpeg -p /sbin/ldconfig
%post -n %{lib_name}-gui -p /sbin/ldconfig
%post -n %{lib_name}-ttf -p /sbin/ldconfig
%post -n %{lib_name}-smalljpeg -p /sbin/ldconfig

%postun -n %{lib_name} -p /sbin/ldconfig
%postun -n %{lib_name}-gl -p /sbin/ldconfig
%postun	-n %{lib_name}-mikmod -p /sbin/ldconfig
%postun	-n %{lib_name}-png -p /sbin/ldconfig
%postun -n %{lib_name}-sound -p /sbin/ldconfig
%postun -n %{lib_name}-vorbis -p /sbin/ldconfig
%postun -n %{lib_name}-network -p /sbin/ldconfig
%postun -n %{lib_name}-jpeg -p /sbin/ldconfig
%postun -n %{lib_name}-gui -p /sbin/ldconfig
%postun -n %{lib_name}-ttf -p /sbin/ldconfig
%postun -n %{lib_name}-smalljpeg -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files -n %{lib_name}
%defattr(-, root, root)
%doc README COPYING CREDITS
%{_libdir}/libclanCore.so.*
%{_libdir}/libclanApp.so.*
%{_libdir}/libclanDisplay.so.*

%files -n %{lib_name}-devel
%defattr(-, root, root)
%doc README COPYING CODING_STYLE ascii-logo NEWS
%{_libdir}/*.so
%{_includedir}/ClanLib/*
%{_bindir}/clanlib-config

%files docs
%defattr(-, root, root)
%{_docdir}/%{name}-docs-%{version}/*

%files -n %{lib_name}-gl
%defattr(-, root, root)
%doc README COPYING
%{_libdir}/libclanGL.so.*

%files -n %{lib_name}-mikmod
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanMikMod.so.*

%files -n %{lib_name}-png
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanPNG.so.*

%files -n %{lib_name}-ttf
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanTTF.so.*

%files -n %{lib_name}-jpeg
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanJPEG.so.*

%files -n %{lib_name}-network
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanNetwork.so.*

%files -n %{lib_name}-vorbis
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanVorbis.so.*

%files -n %{lib_name}-smalljpeg
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanSmallJPEG.so.*

%files -n %{lib_name}-sound
%defattr(-, root, root)
%{prefix}/lib/libclanSound.so.*

%files -n %{lib_name}-gui
%defattr(-, root, root)
%{prefix}/lib/libclanGUI.so.*

#%files mpeg
#%defattr(-, root, root)
#%{prefix}/lib/libclanMPEG.so*

%changelog
* Tue Nov 1 2001 Jeroen Janssen <japj@clanlib.org> 0.5.1-1mdk
- spec update for official 0.5.1 release

* Wed Oct 31 2001 Jeroen Janssen <japj@clanlib.org> 0.5.1-0.CVS.20011031
- upgraded to 0.5.1 CVS

* Fri Oct 12 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.5.0-5mdk
- have good compilation option for PPC (stew)
- rebuild for libpng3
- fix invalid-spec-name 
- fix obsolete-tag Copyright
- better lib policy respect with Provides

* Mon Sep 10 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.5.0-4mdk
- we don't need launch_x11_clanapp anymore with 0.5

* Thu Aug 30 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.5.0-3mdk
- rebuild to fix distribution tag and provides

* Sat Jun 30 2001 Stefan van der Eijk <stefan@eijk.nu> 0.5.0-2mdk
- BuildRequires:	freetype-devel --> freetype2-devel
- Removed BuildRequires:	XFree86-devel, zlib-devel

* Tue Jun 26 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.5.0-1mdk
- release 0.5.0

* Thu Apr 12 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-25mdk
- don't block forever on a busy dsp (patch #5)

* Fri Mar 30 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-24mdk
- use no-omit-frame-pointer to workaround g++ exceptions bug

* Thu Mar 22 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-23mdk
- remove explicit requires on requires, silly me

* Fri Mar  9 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-22mdk
- recompile without svgalib

* Fri Feb 16 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-21mdk
- do not put the launch_x11_clanapp script in the lib package!
- provides devel-lib with version
- put subpackages' devel files in generic devel package

* Mon Feb 12 2001 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-20mdk
- fix BuildRequires (libbzip2-devel, thx to Jeff)

* Fri Dec  8 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-19mdk
- fix BuildRequires

* Tue Nov 28 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-18mdk
- new lib policy

* Tue Nov  7 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-17mdk
- provides ClanLib for compatibility

* Fri Nov  3 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-16mdk
- rebuild to have correct deps (e.g. sucking libraries linked to themselves)
- change name to clanlib (e.g. uppercase names suck)
- rebuild against lowercased hermes

* Fri Nov  3 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-15mdk
- really recompile against newest libstdc++

* Fri Nov  3 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-14mdk
- recompile against newest libstdc++

* Mon Oct 16 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-13mdk
- fix no-newline-at-end-of-some-sourcefiles that bothers gcc-2.96

* Mon Oct 16 2000 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.4.4-12mdk
- Fix gcc2.96 compilation;

* Sun Sep 17 2000 David BAUDENS <baudens@mandrakesoft.com> 0.4.4-11mdk
- Don't use i386 code on non i386 compatibles archs
- Let configure do is job on PPC (and really don't use i386 code)

* Fri Sep 15 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-10mdk
- rebuild against fixed XFree-4 by fredl

* Fri Sep  8 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-9mdk
- fixed BuildRequires: removed ClanLib-devel, added XFree86-static-libs,
  ImageMagick >= 5.0.0
- removed nasty static -march=pentium, /me sucks

* Wed Sep  6 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-8mdk
- added the optional force of x11 target (envvar CLANLIB_FORCE_X11_DISPLAY)
- added a script to launch clanlib apps with force x11 target

* Wed Aug 30 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-7mdk
- added more documentation in subpackages

* Wed Aug 23 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-6mdk
- automatically added packager tag

* Wed Aug 23 2000 Frederic Lepied <flepied@mandrakesoft.com> 0.4.4-5mdk
- corrected BuildRequires for archs other than ix86.

* Tue Aug 08 2000 Frederic Lepied <flepied@mandrakesoft.com> 0.4.4-4mdk
- automatically added BuildRequires

* Tue Aug  1 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-3mdk
- not 100% sure with the 2mdk

* Mon Jul 31 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-2mdk
- integrated patch to ImageMagick stuff from the clanlib-devel mailing
  list, thanks to the help of Ingo Ruhnke <grumbel@gmx.de>; it was a
  contribution from Matt Kimball <mkimball@veriomail.com>

* Mon Jul 31 2000 Guillaume Cottenceau <gc@mandrakesoft.com> 0.4.4-1mdk
- took SRPM from ClanLib web site
- Mandrake adaptations
- ugly: take the Magick stuff from CVS to compile with ImageMagick 5
- mega headache; had to redefine CXXFLAGS to remove -mcpu=pentiumpro
