%define name clanlib
%define version	0.5.4

# the way release works is as follows (based upon "official" Mandrake naming convention)
# 0.5.4-1mdk			official release of ClanLib 0.5.3 (rpm build 1)
# 0.5.4-0.20010504.1mdk		"snapshot" release of (a pre) ClanLib 0.5.4 from date 2001/05/04

%define release 0.20010512.1mdk

%define prefix %{_prefix}
%define lib_name_orig libclanlib
%define lib_major 1
%define lib_name %{lib_name_orig}%{lib_major}

Name: %{name}
Summary: The ClanLib Game SDK
Version: %{version}
Release: %{release}
Copyright: LGPL
Group: System/Libraries
Source: ClanLib-%{version}.tar.gz
URL: http://clanlib.org/
Packager: Jeroen Janssen <japj@clanlib.org>
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildRequires: libhermes-devel >= 1.3.0 zlib-devel bzip2 libbzip2-devel
#%ifarch %{ix86}
#BuildRequires: svgalib-devel
#%endif
Obsoletes: ClanLib

%description
The ClanLib Game SDK is a crossplatform game library designed to ease the work
for game developers. The goal is to provide a common interface to classical
game problems (loading graphics eg.), so games can share as much code as
possible. Ideally anyone with small resources should be able to write
commercial quality games.


%package -n %{lib_name}
Summary: Main library for %{name}
Group: System/Libraries

%description -n %{lib_name}
This package contains the library needed to run programs dynamically
linked with %{name}.


%package -n %{lib_name}-devel
Summary: Headers for developing programs that will use %{name}
Group: Development/C++
Requires: %{lib_name} = %{version} 
Provides: %{lib_name_orig}-devel = %{version}-%{release}
Obsoletes: ClanLib-devel clanlib-devel

%description -n %{lib_name}-devel
This package contains the headers that programmers will need to develop
applications which will use %{name}.


#%package -n %{lib_name}-gl
#Summary: ClanLib OpenGL module
#Group: System/Libraries
#Requires: %{lib_name} = %{version} Mesa %{lib_name}-display
#BuildRequires: Mesa-common-devel
#Obsoletes: ClanLib-gl clanlib-gl
#
#%description -n %{lib_name}-gl
#The ClanLib Game SDK is a crossplatform game library designed to ease the
#work for game developers. This package is the OpenGL module (clanGL).


%package -n %{lib_name}-mikmod
Summary: ClanLib MikMod module
Group: System/Libraries
Requires: %{lib_name} = %{version} libmikmod %{lib_name}-sound
BuildRequires: libmikmod-devel
Obsoletes: ClanLib-mikmod clanlib-mikmod

%description -n %{lib_name}-mikmod
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the MikMod module (clanMikMod).


%package -n %{lib_name}-png
Summary: ClanLib PNG module
Group: System/Libraries
Requires: %{lib_name} = %{version} libpng %{lib_name}-display
BuildRequires: libpng-devel
Obsoletes: ClanLib-png clanlib-png

%description -n %{lib_name}-png
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the PNG module (clanPNG).


#%package docs
#Summary: ClanLib documentation
#Group: System/Libraries
#Obsoletes: ClanLib-docs clanlib-docs
#
#%description docs
#The ClanLib Game SDK is a crossplatform game library designed to ease the
#work for game developers. This package contains the documentation.


%package -n %{lib_name}-gui
Summary: ClanLib GUI module
Group: System/Libraries
Requires: %{lib_name} = %{version} %{lib_name}-display
Obsoletes: ClanLib-gui clanlib-gui

%description -n %{lib_name}-gui
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the GUI module (clanGUI).


%package -n %{lib_name}-app
Summary: ClanLib Application module
Group: System/Libraries
Requires: %{lib_name} = %{version} 
Obsoletes: ClanLib-app clanlib-app

%description -n %{lib_name}-app
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Application module (clanApp).


%package -n %{lib_name}-display
Summary: ClanLib Display module
Group: System/Libraries
Requires: %{lib_name} = %{version} XFree86-static-libs
BuildRequires: XFree86-devel
Obsoletes: ClanLib-display clanlib-display

%description -n %{lib_name}-display
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Display module (clanDisplay).


%package -n %{lib_name}-jpeg
Summary: ClanLib JPEG module
Group: System/Libraries
Requires: %{lib_name} = %{version} libjpeg %{lib_name}-display
BuildRequires: libjpeg-devel
Obsoletes: ClanLib-jpeg clanlib-jpeg

%description -n %{lib_name}-jpeg
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the JPEG module (clanJPEG).


%package -n %{lib_name}-network
Summary: ClanLib Network module
Group: System/Libraries
Requires: %{lib_name} = %{version}
Obsoletes: ClanLib-network clanlib-network

%description -n %{lib_name}-network
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Network module (clanNetwork).


%package -n %{lib_name}-sound
Summary: ClanLib Sound module
Group: System/Libraries
Requires: %{lib_name} = %{version}
Obsoletes: ClanLib-sound clanlib-sound

%description -n %{lib_name}-sound
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Sound module (clanSound).


%package -n %{lib_name}-smalljpeg
Summary: ClanLib SmallJPEG module
Group: System/Libraries
Requires: %{lib_name} = %{version} %{lib_name}-display
Obsoletes: ClanLib-smalljpeg clanlib-smalljpeg

%description -n %{lib_name}-smalljpeg
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the SmallJPEG module (clanSmallJPEG).


%package -n %{lib_name}-lua
Summary: ClanLib LUA module
Group: System/Libraries
Requires: %{lib_name} = %{version} lua
BuildRequires: lua
Obsoletes: ClanLib-lua clanlib-lua

%description -n %{lib_name}-lua
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the LUA module (clanLUA).


%package -n %{lib_name}-vorbis
Summary: ClanLib Vorbis module
Group: System/Libraries
Requires: %{lib_name} = %{version} libogg0 libvorbis0 %{lib_name}-sound
BuildRequires: libogg0-devel libvorbis0-devel
Obsoletes: ClanLib-vorbis clanlib-vorbis

%description -n %{lib_name}-vorbis
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the Vorbis module (clanVorbis).


%package -n %{lib_name}-ttf
Summary: ClanLib TTF module
Group: System/Libraries
Requires: %{lib_name} = %{version} freetype2 %{lib_name}-display
BuildRequires: freetype2-devel
Obsoletes: ClanLib-ttf clanlib-ttf

%description -n %{lib_name}-ttf
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the TTF module (clanTTF).



%prep
%setup -n ClanLib-%{version}
# remove nasty no-newline-at-end-of-line, it bothers gcc-2.96
find . -name "*.h"   -exec perl -pi -e '$_.="\n" if eof' {} \;
find . -name "*.cpp" -exec perl -pi -e '$_.="\n" if eof' {} \;

%build
# (gc) workaround g++ exception bug when -fomit-frame-pointer is set
export CFLAGS="$RPM_OPT_FLAGS -fno-omit-frame-pointer" CXXFLAGS="$RPM_OPT_FLAGS -fno-omit-frame-pointer"
./autogen.sh

%ifarch %{ix86}
  %configure --enable-x11 --disable-fbdev --enable-joystick --disable-ggi --enable-opengl --disable-svgalib --enable-clansound --enable-network --enable-gui --enable-lua --enable-mikmod --enable-png --enable-jpeg --enable-smalljpeg --enable-vorbis --enable-ttf --enable-asm386 --enable-dyn --disable-directfb
%endif

# (Dadou) GG put some non usuable options in %ifnarch ix86 (like svga)
# configure do a (nearly nice job), so let it plays
%ifarch ppc
	%configure --disable-asm386
%endif

%ifnarch %{ix86} ppc
  %configure --enable-x11 --enable-fbdev --enable-opengl --disable-svgalib --enable-clansound --enable-network --enable-dyn --disable-asm386
%endif

make clanCore
make clanApp
make clanDisplay
make clanSound
make clanJPEG
make clanNetwork
make clanSmallJPEG
#make clanGL
make clanMikMod
make clanGUI
make clanVorbis
make clanTTF

make clanLua
#make clanMPEG
make clanPNG
make strip
make docs

%install
%makeinstall BIN_PREFIX=$RPM_BUILD_ROOT%{_bindir} LIB_PREFIX=$RPM_BUILD_ROOT%{_libdir} INC_PREFIX=$RPM_BUILD_ROOT%{_includedir}
make MAN_PREFIX=$RPM_BUILD_ROOT%{_mandir} HTML_PREFIX=$RPM_BUILD_ROOT%{_datadir}/doc/%{name}-docs-%{version}/Documentation EXAMPLE_SRC_PREFIX=$RPM_BUILD_ROOT%{_datadir}/doc/%{name}-docs-%{version}/Examples docs_install

%post -n %{lib_name} -p /sbin/ldconfig

#%post -n %{lib_name}-gl -p /sbin/ldconfig

%post -n %{lib_name}-mikmod -p /sbin/ldconfig

%post -n %{lib_name}-png -p /sbin/ldconfig

%post -n %{lib_name}-gui -p /sbin/ldconfig

%post -n %{lib_name}-app -p /sbin/ldconfig

%post -n %{lib_name}-display -p /sbin/ldconfig

%post -n %{lib_name}-jpeg -p /sbin/ldconfig

%post -n %{lib_name}-network -p /sbin/ldconfig

%post -n %{lib_name}-sound -p /sbin/ldconfig

%post -n %{lib_name}-smalljpeg -p /sbin/ldconfig

%post -n %{lib_name}-lua -p /sbin/ldconfig

%post -n %{lib_name}-vorbis -p /sbin/ldconfig

%post -n %{lib_name}-ttf -p /sbin/ldconfig



%postun -n %{lib_name} -p /sbin/ldconfig

#%postun	-n %{lib_name}-gl -p /sbin/ldconfig

%postun	-n %{lib_name}-mikmod -p /sbin/ldconfig

%postun	-n %{lib_name}-png -p /sbin/ldconfig

%postun	-n %{lib_name}-gui -p /sbin/ldconfig

%postun	-n %{lib_name}-app -p /sbin/ldconfig

%postun	-n %{lib_name}-display -p /sbin/ldconfig

%postun	-n %{lib_name}-jpeg -p /sbin/ldconfig

%postun	-n %{lib_name}-network -p /sbin/ldconfig

%postun	-n %{lib_name}-sound -p /sbin/ldconfig

%postun	-n %{lib_name}-smalljpeg -p /sbin/ldconfig

%postun	-n %{lib_name}-lua -p /sbin/ldconfig

%postun	-n %{lib_name}-vorbis -p /sbin/ldconfig

%postun	-n %{lib_name}-ttf -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

#%files
#%defattr(-, root, root)
#%doc README

%files -n %{lib_name}
%defattr(-, root, root)
%doc README COPYING CREDITS
%{_libdir}/libclanCore.so.*

%files -n %{lib_name}-devel
%defattr(-, root, root)
%doc README COPYING CREDITS CODING_STYLE BUGS PORTING README.fbdev README.gui README.upgrade ascii-logo
%{_libdir}/*.so
%{_includedir}/ClanLib/*
%{_bindir}/clanlib-config

#%files docs
#%defattr(-, root, root)
##%doc README COPYING CREDITS CODING_STYLE BUGS PORTING README.fbdev README.gui README.upgrade 
#%{_docdir}/%{name}-docs-%{version}/*
##%{_mandir}/man1/datafile_compiler.1*
##%{_mandir}/man3/CL*
##%{_mandir}/man3/clanlib.3*

#%files -n %{lib_name}-gl
#%defattr(-, root, root)
#%doc README COPYING 
#%{_libdir}/libclanGL.so.*

%files -n %{lib_name}-mikmod
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanMikMod.so.*

%files -n %{lib_name}-png
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanPNG.so.*

%files -n %{lib_name}-gui
%defattr(-, root, root)
%doc README COPYING README.gui
%{_libdir}/libclanGUI.so*

%files -n %{lib_name}-app
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanApp.so.*

%files -n %{lib_name}-display
%defattr(-, root, root)
%doc README COPYING README.fbdev
%{_libdir}/libclanDisplay.so.*

%files -n %{lib_name}-jpeg
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanJPEG.so.*

%files -n %{lib_name}-network
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanNetwork.so.*

%files -n %{lib_name}-sound
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanSound.so.*

%files -n %{lib_name}-smalljpeg
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanSmallJPEG.so.*

%files -n %{lib_name}-lua
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanLua.so.*

%files -n %{lib_name}-vorbis
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanVorbis.so.*

%files -n %{lib_name}-ttf
%defattr(-, root, root)
%doc README COPYING 
%{_libdir}/libclanTTF.so.*


%changelog
 * Sat May 12 2001 Jeroen Janssen <japj@clanlib.org>
 - disabling DirectFB for the moment
 
 * Fri May 04 2001 Jeroen Janssen <japj@clanlib.org>
 - disabled doc building for the moment (until it's properly fixed, just grab the tar.gz for now)
 - changed to "official" Mandake version/release naming convention (thanks to Guillaume Cottenceau)
 
 * Sat Apr 28 2001 Jeroen Janssen <japj@clanlib.org>
 - added some more docs to the devel rpm
 
 * Fri Apr 27 2001 Jeroen Janssen <japj@clanlib.org>
 - some preparations for official release of ClanLib-0.5.0 (note *NO* GL support)
 - updated documentation generation 
 - added lua build dependency
 
 * Wed Apr 25 2001 Jeroen Janssen <japj@clanlib.org>
 - added vorbis & ttf
 - (hopefully) added some usefull dependencies
 - added more interdependant package relations (mainly display/sound related)

 * Tue Apr 24 2001	Jeroen Janssen <japj@clanlib.org>
 - added clanLua + configuration updates
	
 * Mon Apr 23 2001	Jeroen Janssen <japj@clanlib.org>
 - initial "spec port" from MDK8-clanlib 0.4.4 to ClanLib CVS 0.5
 - added gui,app,display,jpeg,network,sound and smalljpeg
 - instructions: put a ClanLib-0.5.0.tar.gz into /usr/src/RPMS/SOURCES,
   go to /usr/src/RPMS/SPECS, put this spec there and run rpm -ba clanlib.spec
   this should result in a bunch of rpms being build.
 


