/*
	$Id: listbox_item.h,v 1.2 2001/12/28 23:45:13 sphair Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Framework"
//! header=listbox_item.h

#ifndef header_listbox_item
#define header_listbox_item

#include <string>

class CL_ListBox_Item
{
public:
	CL_ListBox_Item() : selected(false) {}

	CL_ListBox_Item(std::string str, bool selected = false)
	{
		this->str = str;
		this->selected = selected;
	}

	bool operator< ( const CL_ListBox_Item &item ) const
	{
		return str < item.str;
	}

	bool operator== ( const CL_ListBox_Item &item ) const
	{
		return str == item.str;
	}

	std::string str;
	bool selected;
};

#endif
