/*
	$Id: popupmenu_generic.cpp,v 1.12 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "popupmenu_generic.h"
#include "API/GUI/component_options.h"
#include "API/GUI/gui_manager.h"

CL_ComponentOptions CL_PopupMenu_Generic::create_options(
	const CL_Point &pos)
{
	CL_ComponentOptions options;

	options.add_option("x", pos.x);
	options.add_option("y", pos.y);
	options.add_option("width", 150);
	options.add_option("height", 8);

	return options;
}

CL_PopupMenu_Generic::CL_PopupMenu_Generic(CL_PopupMenu *self, const CL_ComponentOptions &options, CL_StyleManager *style)
:
	popupmenu(self)
{
	slot_lost_focus = popupmenu->sig_lost_focus().connect(
		this, &CL_PopupMenu_Generic::on_lost_focus);
	slot_child_add = popupmenu->sig_child_before_add().connect(
		this, &CL_PopupMenu_Generic::on_child_add);
}

CL_PopupMenu_Generic::~CL_PopupMenu_Generic()
{
}

void CL_PopupMenu_Generic::on_lost_focus()
{
	sig_cancelled();

//	popupmenu->close();
}

void CL_PopupMenu_Generic::on_child_add(CL_Component *child)
{
	CL_Rect children_rect = popupmenu->get_children_rect();

	// Move first child down abit
	if(children_rect.y2 == 0)
		children_rect.y2 = 4;

	// Move and resize child to fit into popupmenu
	CL_Rect rect(4, children_rect.y2 + 1, popupmenu->get_width() - 4, children_rect.y2 + child->get_height());
	child->set_position(rect);

	// Resize popupmenu height according to children
	int height = popupmenu->get_height();
	if(rect.y2 + 4 > height)
	{
		height = rect.y2 + 4;
		popupmenu->set_height(height);
	}

	// Hook into clicking on the child
	if(child->is_enabled())
	{
		CL_Slot *slot = new CL_Slot(child->sig_mouse_up().connect(
			this, &CL_PopupMenu_Generic::on_child_click, child));
		slots_child_click.push_back(slot);
	}
}

void CL_PopupMenu_Generic::on_child_click(const CL_Key &key, CL_Component *component)
{
	const std::list<CL_Component *> children = component->get_children();
	if(children.size())
	{
		CL_Component *submenu = *(children.begin());
		component->remove_child(submenu);
		popupmenu->get_gui_manager()->add_child(submenu);

		CL_Rect pos = popupmenu->get_screen_rect();
		CL_Rect comp_pos = component->get_screen_rect();
		submenu->set_position(pos.x1 + popupmenu->get_width(), comp_pos.y1);
		submenu->set_focus();
		submenu->show();
	}
	else
		popupmenu->close();
}
