#include <ClanLib/core.h>
#include <ClanLib/mikmod.h>
#include <ClanLib/sound.h>
#include <ClanLib/application.h>

class MyApp : public CL_ClanApplication
{
public:
	virtual char *get_title()
	{
		return "clanMikMod test application.";
	}

	virtual int main(int argc, char** argv)
	{
		// Create a console window for text-output if not available
		CL_ConsoleWindow console("Console");
		console.redirect_stdio();

		try
		{
			CL_SetupCore::init();
			CL_SetupSound::init();
			CL_SetupMikMod::init();

			CL_SoundBuffer *sample = new CL_SoundBuffer(
				new CL_Streamed_MikModSample("clanbeat.xm"),
				true);

			CL_SoundBuffer_Session playback(sample->prepare());

			std::cout << "Playing module session..." << std::endl;

			playback.play();
		
			while (playback.is_playing())
			{
				CL_System::sleep(10);
				CL_System::keep_alive();
			}

			//delete sample; to this and you'll get a crash

			CL_SetupMikMod::deinit();
			CL_SetupSound::deinit();
			CL_SetupCore::deinit();
		}
		catch (CL_Error err)
		{
			std::cout << "error: " << err.message.c_str() << std::endl;

			// Display console close message and wait for a key
			console.display_close_message();

			return -1;
		}

		return 0;
	}
} app;
