/*
        put_target/ CL_Canvas test app.
*/

#include <ClanLib/core.h>

class DrawingApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Drawing application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupCore::init_display();
	}
	
	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}
	
	virtual int main(int, char **)
	{
		try
		{
			CL_Display::set_videomode(320,200,16);

			CL_Canvas *src_canvas = new CL_Canvas(320, 200, 1, 
							      CL_Color::get_red_mask(RGB565),
							      CL_Color::get_green_mask(RGB565),
							      CL_Color::get_blue_mask(RGB565),
							      CL_Color::get_alpha_mask(RGB565),
							      true,
							      0); // transcol == black
		
			CL_Canvas *dst_canvas = new CL_Canvas(320, 200, 1, 
							      CL_Color::get_red_mask(RGB565),
							      CL_Color::get_green_mask(RGB565),
							      CL_Color::get_blue_mask(RGB565),
							      CL_Color::get_alpha_mask(RGB565));
	
			src_canvas->fill_rect(0, 0, 319, 199, 1.0, 1.0, 1.0, 1.0);
			//we need fillrect int color with transcol!!!
			src_canvas->fill_rect(160, 0, 319, 199, 0.0, 0.0, 0.0, 1.0);

			dst_canvas->fill_rect(0, 0, 319, 199, 0.0, 0.0, 1.0, 1.0);

			CL_Surface *src_surface = CL_Surface::create(src_canvas);
			src_surface->put_target(0,0,0, dst_canvas);
	
			CL_Surface *dst_surface = CL_Surface::create(dst_canvas);
			dst_surface->put_screen(0,0);
			
			CL_Display::flip_display();
			CL_System::sleep(1500);

			delete src_canvas;
			delete dst_canvas;
			delete src_surface;
			delete dst_surface;

			return 0;
		}
		catch (CL_Error err)
		{
			std::cout << "Exception caught: " << err.message.c_str() << std::endl;
			return -1;
		}
		return -1;
	}
} app;
