#include <ClanLib/core.h>
#include <ClanLib/gui.h>

class myApp : public CL_ClanApplication, public CL_GApplication
{
public:
virtual char *get_title() { return "GUI Test"; }

myApp()
{
	register_slot(cl_slot(echo));
}
virtual void init_modules(){CL_SetupCore::init_display();
CL_SetupCore::init();}
virtual void deinit_modules(){CL_SetupCore::deinit_display();}
virtual ~myApp() 
{
	deregister_slot(cl_slot(echo));
};

DEF_SLOT_1(echo, CL_GButton*);

virtual int main(int argc, char **argv)
{
	// initialize the gui system
	init(320, 200, 16, true);
	CL_ResourceManager *myimages;
	myimages=CL_ResourceManager::create("gui.dat",true);
	// create a quit button and connect its 'clicked' signal to our 'quit' slot
	// defined in CL_GApplication.
        CL_Font *fnt=CL_Font::load("Fonts/simple_font",myimages);
	CL_GTextfield *textfield=new CL_GTextfield(rootWindow(),60,80,100,50);
	CL_GButton *btnQuit = new CL_GButton(rootWindow(), 5, 5, 50, 50, 1001);
	connect(btnQuit, cl_signal(CL_GButton::clicked),
		this, cl_slot(quit));
	
	// create a second button, its pressed and released signals are connected
	// to our echo slot.
	CL_GButton *btnEcho = new CL_GButton(rootWindow(), 5, 55, 50, 50, 1002);
	connect(btnEcho, cl_signal(CL_GButton::pressed),
		this, cl_slot(echo));
	connect(btnEcho, cl_signal(CL_GButton::released),
		this, cl_slot(echo));
	CL_GLabel *label= new CL_GLabel(rootWindow(),60,30,100,50,fnt); 
	label->set_text("this is a label");
	// start the event loop
	exec();

	// cleanup
	delete btnQuit;
	delete btnEcho;
	delete label;
	return 0;
}


virtual int startupProc(void)
{
	cout << "starting up..." <<endl;
	return 0;
}

virtual bool handleEvent(const CL_GEvent *event)
{
	bool handled = CL_GApplication::handleEvent(event);
	
	if (!handled)
	{
		switch (event->type())
		{
			/* handle keyboard events */
			case (CL_GEvent::KEY):
			{
				CL_GKeyEvent *e = (CL_GKeyEvent*)event;
				
				// ignore the RELEASED event
				if (e->get_state() == CL_GKeyEvent::PRESSED)
				{
					CL_Key k = e->get_key();
					cout << "key event: key = " << k.id << endl;
					if (k.id == CL_KEY_ESCAPE)
					{
						quit(0);
						handled = true;
					}
				}
			}
				break;			
			

			default:
				break;
		} // end switch
	}
	
	return handled;
}

virtual int eventloopProc(void)
{
	a++;
}

virtual int shutdownProc(void)
{
	cout << "shutting down..." <<endl;
	return 0;
}

private:
	int a;

} app;


void myApp::echo(CL_GButton *btn)
{
	if (btn->get_pressed())
		cout << "button " << btn->get_id() << " pressed" << endl;
	else
        	cout << "button " << btn->get_id() << " released" << endl;
}   
