/*
	Demonstration of the CL_Mouse interface:
*/

#include <ClanLib/core.h>

class MouseApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "Mouse application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		CL_SetupCore::init_display();

		// Set mode: 320x240 16 bpp
		CL_Display::set_videomode(320, 240, 16, false);
		
		// Make sure the display is black at startup:
		CL_Display::clear_display();

		CL_ResourceManager *manager = CL_ResourceManager::create("mouse.scr", false);
		CL_MouseCursor::set_cursor(CL_MouseCursorProvider::load("sur_cursor", manager));

		CL_Display::clear_display();
		CL_Display::flip_display();
		CL_Display::clear_display();
		CL_Display::flip_display();
		// Loop until the user hits the left mouse button:
		try
		{
			while (
				CL_Mouse::left_pressed() == false &&
				CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				// Clear display with alpha background:
				CL_Display::clear_display(0.0f, 0.0f, 0.5f, 1.0f);
			
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
			
				// Update keyboard input and handle system events:
				CL_System::keep_alive();
			}
		}
		catch (CL_Error err)
		{
			return 1;
		}

		delete manager;

		return 0;
	}
} app;
