/*
	Example of writing your own static soundprovider.
*/

#include <ClanLib/core.h>
#include <math.h>

class OurStaticSoundProvider : public CL_StaticSoundProvider
{
public:
	OurStaticSoundProvider();
	virtual ~OurStaticSoundProvider();

	virtual void lock();
	virtual void unlock();
	virtual SoundFormat get_format() const;
	virtual int data_size() const;
	virtual void *get_data() const;
	virtual int get_frequency() const;

private:
	int lock_refs;
	short *buffer;
};

class StaticSoundProviderApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "StaticSoundProvider application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		CL_SetupCore::init_sound();

		CL_SoundBuffer *soundbuffer = CL_SoundBuffer::create(
			new OurStaticSoundProvider,
			true); // true -> delete provider when soundbuffer is deleted

		soundbuffer->play(true);

		CL_System::sleep(2000);
		soundbuffer->stop();
		
		delete soundbuffer;
		CL_SetupCore::deinit_sound();

		return 0;
	}
} app;

OurStaticSoundProvider::OurStaticSoundProvider()
{
	lock_refs = 0;
	buffer = NULL;
}

OurStaticSoundProvider::~OurStaticSoundProvider()
{
	delete[] buffer;
}

void OurStaticSoundProvider::lock()
{
	if (lock_refs == 0)
	{
		buffer = new short[22050];
		
		for (int i=0; i<22050; i++)
		{
			buffer[i] = (short) (sin(i*6.28/100)*32000);
		}
	}
	
	lock_refs++;
}

void OurStaticSoundProvider::unlock()
{
	lock_refs--;
	
	if (lock_refs == 0)
	{
		delete[] buffer;
		buffer = NULL;
	}
}

SoundFormat OurStaticSoundProvider::get_format() const
{
	return sf_16bit_signed;
}

int OurStaticSoundProvider::data_size() const
{
	return sizeof(short)*22050;
}

void *OurStaticSoundProvider::get_data() const
{
	return buffer;
}

int OurStaticSoundProvider::get_frequency() const
{
	return 22050;
}
