/*
	$Id: netobject_creator.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="NetObjects"

#ifndef header_netobject_creator
#define header_netobject_creator

class CL_NetObject;
class CL_NetObjectCreator
//: NetObject creation interface.
// CL_NetObjectCreator is used by NetObjectControllers to create a
// new slave netobject based on its type ID and a creation packet.
//
// Inherit and implement this class to use the netobjects.
{
public:
	virtual ~CL_NetObjectCreator() { return; }

	virtual CL_NetObject *create(int type, CL_InputSource *input)=0;
};

#endif
