/*
	$Id: stream_provider_wave.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Streamed sample header file
*/

//! component="Streamed SoundProviders"

#ifndef header_streamed_wave_sample
#define header_streamed_wave_sample

#include <stdlib.h>
#include "../../stl.h"
#include "../Sound/stream_soundprovider.h"
#include "../Sound/soundbuffer.h"

class CL_Streamed_WaveSample : public CL_StreamSoundProvider
//: Streamed sample in wave (.wav) format.
// This class providers playback support for wave (.wav) samples.
// <br>
// Unlike CL_Sample, this class doesn't load the entire PCM stream into
// memory. Instead it slowly loads it from disk as the data is needed. With
// very large samples, this is a very good idea.
// <br>
// If the sample is small and used a lot, you should consider using
// CL_Sample instead.
//!also: CL_Sample - The static wave sample provider.
//!also: CL_Sample_Raw - The static raw sample provider.
//!also: CL_Streamed_RawSample - The streamed raw sample provider.
//!also: CL_SoundBuffer - Sound playback class in ClanLib.
//!also: CL_StreamSoundProvider - Streamed sound provider interface.
//!also: CL_StaticSoundProvider - Static sound provider interface.
{
protected:
	std::string filename;
	CL_InputSourceProvider *inputprovider;
	bool looped;

public:
	static CL_SoundBuffer *create(const char *filename, CL_InputSourceProvider *inputprovider = NULL, bool looped = false);
	// Creates a soundbuffer using this provider.
	//!param: filename - Filename of the wave file.
	//!param: inputprovider - Input source (datafile, regular file). If NULL
	//!param: it defaults to a regular file.
	//!param: looped - True if the streamed should be looped (stream never ends).
	//!retval: The soundbuffer created.

	CL_Streamed_WaveSample(const char *filename, CL_InputSourceProvider *inputprovider = NULL, bool looped = false);
	// Constructs an instance of this class.
	//!param: filename - Filename of the raw PCM stream.
	//!param: frequency - Default playback frequency.
	//!param: inputprovider - Input source (datafile, regular file). If NULL
	//!param: it defaults to a regular file.
	//!param: looped - True if the streamed should be looped (stream never ends).

	virtual ~CL_Streamed_WaveSample();

	virtual CL_StreamSoundProvider_Session *begin_session();
	// Called by the sound implementation when a session is begun.

	virtual void end_session(CL_StreamSoundProvider_Session *session);
	// Called by the sound implementation just before a playback session has
	// ended.
};

class CL_Streamed_WaveSample_Session : public CL_StreamSoundProvider_Session
{
protected:
	CL_InputSource *input;

	struct WAVE_FORMAT
	{
		short formatTag;
		short nChannels;
		int nSamplesPerSec;
		int nAvgBytesPerSec;
		short nBlockAlign;
	};

	SoundFormat sample_format;
	int sample_size;
	int sample_freq;
	int sample_left;
	bool looped;

public:
	CL_Streamed_WaveSample_Session(CL_InputSource *input, bool looped);
	virtual ~CL_Streamed_WaveSample_Session();

	virtual void stop() {}; //FIXME
	virtual bool play() { return false; }; //FIXME
	virtual bool set_position(int pos) { pos=pos; return false; }; //FIXME
	
	virtual bool eof() const;
	virtual int get_data(void *data_ptr, int data_requested);
	virtual int get_frequency() const;
	virtual SoundFormat get_format() const;
};

#endif
