/*
	$Id: sprite_subsection_provider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Subsection surface provider header file

*/

//! component="SurfaceProviders"

#ifndef header_sprite_subsection_provider
#define header_sprite_subsection_provider

#include "generic_surfaceprovider.h"

class CL_SpriteSubsectionProvider : public CL_SurfaceProvider_Generic
{
	CL_SurfaceProvider *parent_provider;
	bool locked;
	int start_x, start_y;
	int width, height;
public:
	static CL_Surface *create(CL_SurfaceProvider *parent_provider, int start_x, int start_y, int width, int height);

	CL_SpriteSubsectionProvider(CL_SurfaceProvider *parent_provider, int start_x, int start_y, int width, int height);
	virtual ~CL_SpriteSubsectionProvider();

	virtual unsigned int get_pitch() const;
	virtual int get_translate_x() const;
	virtual int get_translate_y() const;
	virtual unsigned int get_width() const;
	virtual unsigned int get_height() const;
	virtual unsigned int get_num_frames() const;
	virtual CL_Palette *get_palette() const;

	virtual bool is_indexed() const;
	virtual bool uses_src_colorkey() const;
	virtual unsigned int get_src_colorkey() const;
	
	virtual unsigned int get_red_mask() const;
	virtual unsigned int get_green_mask() const;
	virtual unsigned int get_blue_mask() const;
	virtual unsigned int get_alpha_mask() const;
	virtual unsigned int get_depth() const;
	
	virtual void *get_data() const;

	virtual void perform_lock();
	virtual void perform_unlock();
};

#endif
