/*
	$Id: cl_gbutton.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/
//#include "cl_gwidget.h"
#include "cl_glabel.h"

#ifndef CL_GBUTTON_H
#define CL_GBUTTON_H

//class CL_GButton : public CL_GWidget
class CL_GButton : public CL_GLabel
{
public:
	CL_GButton(CL_GWidget *parent, int x, int y, int w, int h, int id);
	virtual ~CL_GButton();
	virtual bool processEvent(const CL_GEvent *e);
	bool get_pressed() { return isPressed; }
	int get_id() { return id_; }
	void set_repeat(bool repeat);
	
	// define the pressed signal, it will pass a pointer to this button to any
	// slots that are connected
	DEF_SIGNAL_1(CL_GButton::clicked, CL_GButton*);
	DEF_SIGNAL_1(CL_GButton::pressed, CL_GButton*);
	DEF_SIGNAL_1(CL_GButton::released, CL_GButton*);
	
	DEF_SLOT_0(press);
	DEF_SLOT_0(release);
	DEF_SLOT_1(repeat, int);
	
protected:
	bool isPressed;
	bool autoRepeat;
	int id_;
};
#endif

