/*
	$Id: netdata_controller.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/
#include "Core/precomp.h"
#include <API/Core/IOData/inputsource_memory.h>
#include <API/Core/IOData/outputsource_memory.h>
#include <API/Core/NetObjects/netdata_controller.h>
#include <API/Core/NetObjects/netobject.h>
#include <API/Core/Network/netcomputer.h>
#include <API/Core/Network/netgame.h>
#include <API/Core/Network/netmessage.h>

#ifndef min
#define min(a, b) ((a<b) ? (a) : (b))
#endif

/*****************************************************************************/

/*void CL_NetFileController::init(CL_NetGame *netgame, int netchannel, CL_NetDataCreator *netcreator)
{
	if(netcreator==NULL)
		netcreator=this;
	CL_NetDataController::init(netgame, netchannel, netcreator);
}

void CL_NetFileController::send(const CL_NetComputer *dest, char *filename, int priority, int type)
{
	cl_assert(game!=NULL);

	CL_NetFileObject *object=new CL_NetFileObject();
	object->set_filename(filename);
		
	CL_NetDataController::send(dest, object, priority, type);
}

CL_NetDataObject *CL_NetFileController::create_data(int type, int size)
{
	cout << "Creating file..." << endl;

	CL_NetFileObject *object=new CL_NetFileObject;
	
	return object;
}
*/
/*****************************************************************************/

CL_NetDataController::CL_NetDataController()
{
	game=NULL;
	channel=0;

	next_object_id = 0;
}

void CL_NetDataController::init(CL_NetGame *netgame, int netchannel, CL_NetObjectCreator *netcreator)
{
	creator=netcreator;
	game=netgame;
	channel=netchannel;
}

void CL_NetDataController::send(const CL_NetComputer *dest, CL_NetDataObject *object, int priority, int type)
{
	cl_assert(game!=NULL);

	CL_NetDataInfo *info=new CL_NetDataInfo(dest, object, next_object_id++, type, priority);
	serverTransfers.add(info);
}

bool CL_NetDataController::update_server_high(int max_priority, const CL_NetComputer *dest)
{
	return(update_server(0, max_priority, dest));
}

bool CL_NetDataController::update_server_low(int min_priority, const CL_NetComputer *dest)
{
	return(update_server(min_priority, -1, dest));
}

bool CL_NetDataController::update_server(int min_priority, int max_priority, const CL_NetComputer *dest)
{
	bool is_finished=true;
	
	cl_assert(game!=NULL);

	for (int i=0; i<serverTransfers.get_num_items(); i++)
	{
		CL_NetDataInfo *info=serverTransfers[i];

		if((info->dest==dest || dest==NULL) && 
			info->priority >= min_priority &&
			info->priority <= max_priority)
		{
			CL_OutputSource_Memory output;
			output.write_int32(info->id);

			if(info->data_pos == info->data_size) {		// END TRANSFER
				delete info;
				serverTransfers.del(i);
			}
			else {
				if(info->init_transfer==true) {			// INIT TRANSFER
					info->init_transfer=false;

					output.write_int32(info->type);
					output.write_int32(info->data_size);

					info->object->serialize_save(&output);
				}
				else {									// TRANSFER
					int packet_size = min(MAX_PACKET_SIZE, info->data_size - info->data_pos);
					
					output.write_int32(info->data_pos);

					info->data_pos -= output.tell();
					info->object->serialize_save(&output, info->data_pos, packet_size);
					info->data_pos += output.size();
				}
	
				game->send(channel, info->dest, CL_NetMessage(output.get_data(), output.size()));
				is_finished=false;
			}
		}
	}

	return is_finished;
}

void CL_NetDataController::update_client()
{
	cl_assert(game!=NULL);
	cl_assert(creator!=NULL);

	while (game->peek(channel))
	{
		CL_NetMessage message = game->receive(channel);
		CL_InputSource_Memory input(message.data, message.size, true);
		
		cl_assert(input.size() > 0);

		bool found=false;
		int netobject_id = input.read_int32();

		for (int i=0; i<clientTransfers.get_num_items(); i++)
		{
			CL_NetDataInfo *info=clientTransfers[i];
			
			// TRANSFER
			if (info->id == netobject_id)	
			{
				int netobject_pos  = input.read_int32();
				int netobject_size = input.size()-input.tell();
				
				info->object->serialize_load(&input, netobject_pos, netobject_size);
				found = true;

				// END TRANSFER
				if(netobject_pos + netobject_size == info->data_size) {
					delete info;
					clientTransfers.del(i);
				}

				break;
			}
		}

		// INIT TRANSFER
		if(found == false)
		{
			int netobject_type = input.read_int32();
			int netobject_size = input.read_int32();

			CL_NetDataObject *object = (CL_NetDataObject *)creator->create(netobject_type, &input);

			if (object != NULL)
			{
				CL_NetDataInfo *info;
				info = new CL_NetDataInfo(object, netobject_id, netobject_type, netobject_size); 
				clientTransfers.add(info);

				object->serialize_load(&input);
			}
		}
	}
}

/*****************************************************************************/

CL_NetDataInfo::CL_NetDataInfo(
	const CL_NetComputer *netdest, CL_NetDataObject *netobject, 
	int netid, int nettype, int netpriority)
{
	dest=netdest;
	object=netobject;

	id=netid;
	type=nettype;
	priority=netpriority;

	data_pos=0;
	data_size=object->get_size();

	init_transfer=true;
}

/*****************************************************************************/

CL_NetDataInfo::CL_NetDataInfo(CL_NetDataObject *netobject, int netid, int nettype, int size)
{
	dest=NULL;
	object=netobject;

	id=netid;
	type=nettype;
	priority=0;

	data_size=size;
	data_pos=0;

	init_transfer=true;
}

/*****************************************************************************/