/*
	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Network delivery implementation - Windows sockets version.
*/

#ifdef USE_NETWORK

#ifndef header_network_delivery_winsocket
#define header_network_delivery_winsocket

#include <list>

#include "Core/Network/Generic/network_delivery_impl.h"

class CL_UDPConnection;

class CL_Win32Socket : public CL_Connection
{
protected:
	SOCKET sock;
	bool is_connection_lost;

	char *cur_message;
	int cur_message_size;

	unsigned long read_int();
	void read_data(void *dest, int size_data);
	void write_int(unsigned long value);
	inline void write_data(void *data, unsigned int size);

	// read from socket:
	enum
	{
		expect_magic,
		expect_packet_size,
		expect_packet_data,
		packet_finished
	} recv_state;

	bool read_avail();
	bool require_avail(int size);
	void get_avail(void *buf, int size);

/*extremely*/ private:
	std::list<char*> avail_buffers;
	int avail_buffer_pos;
	int avail_buffer_end;

public:
	virtual SOCKET get_socket() { return sock; }

	CL_Win32Socket();
	virtual ~CL_Win32Socket();

	// CL_Win32Socket defined virtual function
	virtual bool try_connect(unsigned long remote_ip_network_format, int port);
	virtual bool init_socket(SOCKET init_socket=INVALID_SOCKET);

	// CL_Connection inherited functions
	virtual bool peek();
	virtual CL_ConnectionPacket receive();
	virtual void send(CL_ConnectionPacket message);
	virtual bool connection_lost();
};

class CL_Win32AcceptSocket : public CL_Win32Socket
{
	bool is_inited;
	int port;
public:
	CL_Win32AcceptSocket();
	virtual ~CL_Win32AcceptSocket();

	bool bind(int port);

	CL_Win32Socket *accept();
	int get_port() { return port; }

	// CL_Win32Socket inherited functions
	virtual bool try_connect(unsigned long remote_ip_network_format, int port);

	// CL_Connection inherited functions
	virtual bool peek();
	virtual CL_ConnectionPacket receive();
	virtual void send(CL_ConnectionPacket message);
	virtual bool connection_lost();
};


class CL_UDPConnection_Win32 : public CL_UDPConnection
{
protected:
	SOCKET sock;
	int port;

public:
	virtual SOCKET get_socket() { return sock; }

	CL_UDPConnection_Win32();
	virtual ~CL_UDPConnection_Win32();

	bool bind(unsigned int port);

	// CL_UDPConnection inherited functions
	virtual bool peek();
	virtual CL_UDPConnectionPacket receive();
	virtual void send(CL_UDPConnectionPacket message);
	virtual void broadcast(CL_UDPConnectionPacket message);
	virtual unsigned int get_port();
};

/*
class CL_Win32PipeConnection : public CL_Connection
{
	HANDLE read, write;
	bool is_connection_lost;

	unsigned long read_int();
	void read_data(void *dest, int size_data);
	void write_int(unsigned long value);
	inline void write_data(void *data, unsigned int size);

public:
	CL_Win32PipeConnection(HANDLE read, HANDLE write);
	virtual ~CL_Win32PipeConnection();

	// CL_Connection inherited functions
	virtual bool peek();
	virtual CL_ConnectionPacket receive();
	virtual void send(CL_ConnectionPacket message);
	virtual bool connection_lost();
};
*/

#endif

#endif // USE_NETWORK