/*
	$Id: soundbuffer_static_clan.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Sound card impl. that uses the ClanSound library.

*/

#include "Core/precomp.h"

#ifdef USE_CLANSOUND

#include <API/Core/Sound/static_soundprovider.h>
#include "API/Core/System/cl_assert.h"
#include <Core/Sound/Generic/cardsoundbuffer_playback.h>
#include <Core/Sound/Generic/cardsoundbuffer_static.h>
#include <Core/Sound/ClanSound/soundbuffer_static_clan.h>
#include <Core/Sound/ClanSound/playback_static.h>
#include <Core/Sound/ClanSound/soundcard_clan.h>

CL_CardBuffer_Static_ClanSound::CL_CardBuffer_Static_ClanSound(
	CL_SoundCard_ClanSound *card,
	CL_StaticSoundProvider *provider,
	CL_SoundBuffer *owner)
: CL_CardSoundBuffer_Static(provider)
{
	this->owner = owner;
	this->card = card;

	provider->lock();
	void *input = provider->get_data();
	int size = provider->data_size();
	switch (provider->get_format())
	{
	case sf_8bit_signed:
		{
			char *input_c = (char *) input;
			num_samples = size;
			data = new short[num_samples*2];
			for (int i=0; i<num_samples; i++)
			{
				data[i*2+0] = (((int) input_c[i])/*-128*/)*256;
				data[i*2+1] = (((int) input_c[i])/*-128*/)*256;
			}
		}
		break;
		
	case sf_8bit_signed_stereo:
		{
			char *input_c = (char *) input;
			num_samples = size/2;
			data = new short[num_samples*2];
			for (int i=0; i<num_samples; i++)
			{
				data[i*2+0] = ((int) input_c[i*2])*256;
				data[i*2+1] = ((int) input_c[i*2+1])*256;
			}
		}
		break;
		
	case sf_16bit_signed:
		{
			short *input_s = (short *) input;
			num_samples = size/2;
			data = new short[num_samples*2];
			for (int i=0; i<num_samples; i++)
			{
				data[i*2+0] = input_s[i];
				data[i*2+1] = input_s[i];
			}
		}
		break;
		
	case sf_16bit_signed_stereo:
		{
			num_samples = size/4;
			data = new short[num_samples*2];
			memcpy(data, input, size);
		}
		break;
		
	default:
		cl_assert(false);
	}
	
	provider->unlock();
}

CL_CardBuffer_Static_ClanSound::~CL_CardBuffer_Static_ClanSound()
{
	delete[] data;
}

CL_CardSoundBuffer_Playback *CL_CardBuffer_Static_ClanSound::prepare()
{
	return new CL_Playback_Static(card, this);
}

#endif
