/*
	$Id: soundbuffer_static_clan.h,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Sound card impl. that uses the ClanSound library.

*/

#ifndef header_soundbuffer_static_clan
#define header_soundbuffer_static_clan

#ifdef USE_CLANSOUND

#include "soundcard_clan.h"
#include "Core/Sound/Generic/soundbuffer_static.h"

class CL_CardBuffer_Static_ClanSound : public CL_CardSoundBuffer_Static
{
protected:
	CL_SoundCard_ClanSound *card;
	short *data;
	int num_samples;
	CL_SoundBuffer *owner;

public:
	CL_CardBuffer_Static_ClanSound(
		CL_SoundCard_ClanSound *card,
		CL_StaticSoundProvider *provider,
		CL_SoundBuffer *owner);

	virtual ~CL_CardBuffer_Static_ClanSound();

	virtual CL_CardSoundBuffer_Playback *prepare();
	
	int get_size() { return num_samples; }
	short *get_data() { return data; }
	
	CL_SoundBuffer *get_owner() { return owner; }
};

#endif /* USE_CLANSOUND */

#endif
