/*
	$Id: soundcard_clan.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#ifdef USE_CLANSOUND

#include <API/Core/System/mutex.h>
#include <API/Core/Sound/static_soundprovider.h>
#include <API/Core/Sound/stream_soundprovider.h>
#include <API/Core/System/thread.h>
#include "API/Core/System/cl_assert.h"
#include <Core/Sound/Generic/cardsoundbuffer_playback.h>
#include <Core/Sound/Generic/cardsoundbuffer_static.h>
#include <Core/Sound/Generic/soundbuffer_stream.h>
#include <Core/Sound/ClanSound/soundcard_clan.h>
#include <Core/Sound/ClanSound/soundbuffer_static_clan.h>
#include <Core/Sound/ClanSound/cardplayback_clan.h>
#include <Core/Sound/ClanSound/playback_stream.h>

CL_SoundCard_ClanSound::CL_SoundCard_ClanSound()
{
	name = "Unix sound card";
	card_no = 0;
	
	mutex = CL_Mutex::create();

	exit_thread = false;
	thread = CL_Thread::create(this);
	thread->start();
}

CL_SoundCard_ClanSound::~CL_SoundCard_ClanSound()
{
	mutex->enter();
	exit_thread = true;
	mutex->leave();
	thread->wait();
	delete thread;
	
	delete mutex;
	mutex = NULL;
}

// Functions inherited from API:
// -----------------------------

CL_StreamSoundProvider *CL_SoundCard_ClanSound::get_microphone()
{
	return NULL;
}

CL_StreamSoundProvider *CL_SoundCard_ClanSound::get_line_in()
{
	return NULL;
}

void CL_SoundCard_ClanSound::stop_all()
{
	// we need a generic strategy for this
}

void CL_SoundCard_ClanSound::set_global_volume(int /*volume*/)
{
	// and this one...
}

void CL_SoundCard_ClanSound::set_global_pan(int /*pan*/)
{
	// and this...
}

// Functions inherited from Generic:
// ---------------------------------

CL_CardSoundBuffer_Static *CL_SoundCard_ClanSound::create_soundbuffer_static(
	CL_SoundBuffer *owner,
	CL_StaticSoundProvider *provider)
{
	return new CL_CardBuffer_Static_ClanSound(this, provider, owner);
}

CL_CardSoundBuffer_Playback *CL_SoundCard_ClanSound::create_cardsoundbuffer_playback_streamed(
	CL_SoundBuffer_Generic_Stream *provider)
{
	return new CL_Playback_Stream(
		this,
		provider->get_stream_provider(),
		provider);
}

// Functions exported to CL_CardSoundBuffer_Playback:
// --------------------------------------------------

void CL_SoundCard_ClanSound::add(CL_CardPlayback_ClanSound *playback)
{
	if (mutex == NULL) return;

	mutex->enter();
	mixer.add(playback);
	mutex->leave();
}

void CL_SoundCard_ClanSound::remove(CL_CardPlayback_ClanSound *playback)
{
	if (mutex == NULL) return;

	mutex->enter();
	mixer.remove(playback);
	mutex->leave();
}

CL_Mutex *CL_SoundCard_ClanSound::get_mutex()
{
	cl_assert(mutex != NULL);
	return mutex;
}

// Private functions:
// ------------------

void CL_SoundCard_ClanSound::run()
{
	while (true)
	{
		mixer.wait();

		if (exit_thread) break;
		mixer.mix(mutex);
	}
}

#endif
