/*
	$Id: provider_mpeg.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		mpeg reader.

*/

#include "Core/precomp.h"

#ifdef USE_LIBMPEG

#include "API/Core/SurfaceProviders/provider_mpeg.h"
#include "API/Core/Display/pixelformat.h"

CL_MPEGProvider::CL_MPEGProvider(const char *filename, int dithermode)
{
	mpeg = fopen(filename, "r");

	// currently only FULL_COLOR_DITHER
	SetMPEGOption(MPEG_DITHER, FULL_COLOR_DITHER);
	OpenMPEG(mpeg, &img);
	
	pixels = new char [img.Size];
	moreframes = true;
}

CL_MPEGProvider::~CL_MPEGProvider()
{
	delete[] pixels;
	fclose(mpeg);
}

void CL_MPEGProvider::rewind()
{
	moreframes = true;
	RewindMPEG(mpeg, &img);
}

unsigned int CL_MPEGProvider::get_framerate() const
{
	// new in 1.2.2
	return img.PictureRate;	
}

unsigned int CL_MPEGProvider::get_width() const
{
	return img.Width;
}

unsigned int CL_MPEGProvider::get_height() const
{
	return img.Height;
}

unsigned int CL_MPEGProvider::get_pitch() const
{
	// as BitmapPad is ignored in the calculation of size - why is it there???
	return img.Size / img.Height;
}

unsigned int CL_MPEGProvider::get_num_frames() const
{
	return 1;
}

unsigned int CL_MPEGProvider::get_red_mask() const
{
	return CL_Color::get_red_mask(get_pixel_format());
}

unsigned int CL_MPEGProvider::get_green_mask() const
{
	return CL_Color::get_green_mask(get_pixel_format());
}

unsigned int CL_MPEGProvider::get_blue_mask() const
{
	return CL_Color::get_blue_mask(get_pixel_format());
}

unsigned int CL_MPEGProvider::get_alpha_mask() const
{
	return CL_Color::get_alpha_mask(get_pixel_format());
}

EPixelFormat CL_MPEGProvider::get_pixel_format() const
{
	return RGB888;
}

CL_Palette *CL_MPEGProvider::get_palette() const
{
	return NULL;
}

bool CL_MPEGProvider::is_indexed() const
{
	return false;
}

bool CL_MPEGProvider::uses_src_colorkey() const
{
	return false;
}

unsigned int CL_MPEGProvider::get_src_colorkey() const
{
	return 0;
}

void *CL_MPEGProvider::get_data() const
{
	return pixels;
}

void CL_MPEGProvider::perform_lock()
{
	if (moreframes) moreframes = GetMPEGFrame(pixels);
}

void CL_MPEGProvider::perform_unlock()
{
}

#endif