/*
	$Id: init_win32.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		This file is the WinMain entry point. It will setup the clanCore
		win32 environment and then afterwards call the ClanApplication
		instance.

		This file also contain the win32 specific implementations
		of the CL_System class.

		The win32 versions of CL_SetupCore functions are also defined here.
*/

#include "Core/precomp.h"
#include "init_win32.h"

#include "Core/Display/DirectDraw/displaycard_directdraw.h"
#include "Core/Sound/DirectSound/soundcard_dx.h"
#include "Core/Sound/DirectSound/sound_dx.h"
#include "Core/Input/Win32/input_dx.h"
#include "Core/NetWork/WinSockets/network_win32.h"

#include <Hermes/hermes.h>

#include <strstream>
#include <conio.h>

class CL_Win32Event_Dispatcher : public CL_KeepAlive
{
public:
	virtual void keep_alive();
};

bool global_uses_opengl = false;
void (*opengl_init_function)()= NULL;

static void calc_commandline(int *argc, char ***argv);
int datafile_main(int argc, char **argv);
/*
DOESN'T WORK. SUE ME!

class CL_DebugStreamBuf : public streambuf
{
protected:
	virtual streamsize xsputn(const char *s, streamsize n)
	{
		std::string str(s, n);
		OutputDebugString(str.c_str());

		return streambuf::xsputn(s, n);
	}
} debug_buf;
*/

static void redirect_to_console(const char *title)
{
	AllocConsole();
	SetConsoleTitle(title);
	COORD coord;
	coord.X = 120;
	coord.Y = 400;
	HANDLE scrbuf =
		CreateConsoleScreenBuffer(
			GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL,
			CONSOLE_TEXTMODE_BUFFER,
			NULL);

	cl_assert(scrbuf != INVALID_HANDLE_VALUE);

	SetConsoleActiveScreenBuffer(scrbuf);
	SetConsoleScreenBufferSize(scrbuf, coord);

	freopen("CONIN$", "wt", stdin);
	freopen("CONOUT$", "wt", stderr);
	freopen("CONOUT$", "wt", stdout);
}

// Welcome to main.
int WINAPI WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR lpCmdLine,
	int nCmdShow)
{
	// If clanlib is compiled in debug mode, allocate a console window.
#ifdef _DEBUG
	redirect_to_console("ClanLib debug console window");
#endif

	std::cout << "$Id: init_win32.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $" << std::endl << std::endl;

	// Redirect C++ output streams to the output window in developer studio:
//	std::cout = iostream(&debug_buf);
//	cerr = iostream(&debug_buf);

	Hermes_Init();

	// Did the game developer remember to create one global application
	// interface?
	if (CL_ClanApplication::app == NULL)
	{
		MessageBox(NULL, "No program instance found", "ClanLib/Win32", 32);
		return 0;
	}

	CL_System_Win32::hInstance = hInstance;

	// Setup a CL_System::keep_alive() listener that will read win32 events
	// and dispatch them.

	CL_Win32Event_Dispatcher event_dispatcher;

	// Get commandline arguments.

	int argc;
	char **argv;
	calc_commandline(&argc, &argv);

	// Now contact the application interface and ask it to initialize the
	// clanlib libraries it needs:

	CL_ClanApplication::app->init_modules();

	// Is this a request for running the datafile compiler?
	if (argc > 1 && strcmp(argv[1], "-datafile")==0)
	{
		redirect_to_console("ClanLib datafile compiler");

		int ret = datafile_main(argc-1, argv+1);
		CL_ClanApplication::app->deinit_modules();

		std::cout << std::endl << "(press any key to close datafile compiler console window)";
		std::cout.flush();
		while (!kbhit()) Sleep(250);
		return ret;
	}

	// Init input (note: this should be altered, too ugly impl.):
	new CL_Input_DX;

	// Finally run the application:
	int ret = CL_ClanApplication::app->main(argc, argv);

	// Shutdown clanlib libs correctly:
	CL_ClanApplication::app->deinit_modules();

	// And then shutdown core anyways - we assume the developer is an idiot!
	CL_SetupCore::deinit_display();
	CL_SetupCore::deinit_sound();
	CL_SetupCore::deinit_network();

	// calc_commandline() doesn't clean up after itself. tsk tsk:
	delete[] argv;

#ifdef _DEBUG
	std::cout << std::endl << "(press any key to close debug console window)";
	std::cout.flush();
	while (!kbhit()) Sleep(250);
#endif

	// phew, got through this without problems.
	return ret;
}

static void calc_commandline(int *argc, char ***argv)
{
	char *command_line = GetCommandLine();
	static std::vector<char *> pos;
//	if (*command_line) pos.push_back(command_line);
	bool state_gaaseoejne = false;
	bool new_arg = true;

	for (;*command_line;command_line++) 
	{
		if (*command_line == '"')
		{
			new_arg = true;
			command_line++;
			char *start_arg = command_line;
			for (;*command_line && *command_line!='"';command_line++)
			{
				if (!isspace(*command_line)) new_arg = false;
			}
			if (new_arg == false) pos.push_back(start_arg);
			if (*command_line == '"') *command_line = 0;
			else if (*command_line == 0) break;
			command_line++;
			if (*command_line == 0) break;
			new_arg = true;
		}
		
		if (new_arg && !isspace(*command_line))
		{
			new_arg = false;
			pos.push_back(command_line);
		}
		else if (!new_arg && isspace(*command_line))
		{
			new_arg = true;
			*command_line = 0;
		}
	}
	int num_words = pos.size();

	char **words = new char*[num_words];

	int i;
	for (i=0; i<num_words; i++)
	{
		words[i] = pos[i];
	}

	*argc = num_words;
	*argv = words;
}

void CL_Win32Event_Dispatcher::keep_alive()
{
	// Check for win32 events and dispatch them to MainMessageHandler().

	MSG msg;

	while (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) == TRUE)
	{
		if (GetMessage(&msg, NULL, 0, 0))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			throw CL_Error("Win32 event dispatcher received WM_QUIT");
		}
	}
}

LONG WINAPI MainMessageHandler(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// Route the win32 events through our Win32 event listener list.
	// If no listener handles the event, pass it on to the default window procedure.

	bool handled = false;

	for (
		std::list<CL_Win32EventListener *>::iterator it = CL_System_Win32::listeners.begin();
		it != CL_System_Win32::listeners.end();
		it++)
	{
		if ((*it)->received_event(uMsg, wParam, lParam)) handled = true;
	}

	if (handled) return TRUE;

	switch (uMsg)
	{
	case WM_CLOSE:
		PostQuitMessage(0);
		break;

	case WM_PAINT:
		{
			PAINTSTRUCT ps;

			BeginPaint(hWnd, &ps);
			EndPaint(hWnd, &ps);
		}
		break;

	default:
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}

	return TRUE;
}

void CL_System_Win32::add_listener(CL_Win32EventListener *listener)
{
	listeners.push_back(listener);
}

void CL_System_Win32::remove_listener(CL_Win32EventListener *listener)
{
	listeners.remove(listener);
}

// Win32 implementation of CL_System functions:

unsigned int CL_System::get_time()
{
	return timeGetTime();
}

void CL_System::sleep(int millis)
{
	Sleep(millis);
}

// Win32 core subsystem initialization.
// If ClanLib under win32 should ever need to use several targets,
// this is the place to add the support.

void CL_SetupCore::init_display()
{
	// todo: enumerate directdraw display cards.

	if (global_uses_opengl && opengl_init_function != NULL)
	{
		opengl_init_function();
	}
	else
	{
		CL_Display::cards.push_back(
			new CL_DisplayCard_DirectDraw(
				0,                // card_no
				NULL,             // card_guid, NULL = default screen,
				"default card")); // card_name
	}
	// todo: Add OpenPTC win32 target here.
}

void CL_SetupCore::deinit_display()
{
	int size = CL_Display::cards.size();
	for (int i = 0; i < size; i++)
	{
		delete CL_Display::cards[i];
	}

	CL_Display::cards.clear();
}

void CL_SetupCore::init_sound()
{
	new CL_Sound_DX;
}

void CL_SetupCore::deinit_sound()
{
	int size = CL_Sound::cards.size();
	for (int i = 0; i < size; i++)
	{
		delete CL_Sound::cards[i];
	}

	CL_Sound::cards.clear();
}

void CL_SetupCore::init_network()
{
#ifdef USE_NETWORK
	new CL_Network_DX();
#endif
}

void CL_SetupCore::deinit_network()
{
#ifdef USE_NETWORK
	delete CL_Network_DX::instance;
	CL_Network_DX::instance = NULL;
#endif
}

// Global vars:

HINSTANCE CL_System_Win32::hInstance = NULL;
std::list<CL_Win32EventListener*> CL_System_Win32::listeners;
