/*
	$Id: cl_grect.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "../API/GUI/cl_grect.h"
#include "../API/GUI/cl_gpoint.h"

#include <iostream.h>

CL_GRect CL_GRect::invalid = CL_GRect(0,0,-1,-1);
CL_GRect CL_GRect::empty = CL_GRect(0,0,0,0);

CL_GRect::CL_GRect( int x, int y, int w, int h) :
  upperLeft_(x,y),
  lowerRight_(x+w, y+h)
{

}

CL_GRect::CL_GRect() :
  upperLeft_(0,0),
  lowerRight_(0,0)
{

}

CL_GRect::CL_GRect(const CL_GPoint &upperLeft, const CL_GPoint &lowerRight) :
  upperLeft_(upperLeft),
  lowerRight_(lowerRight)
{

}

CL_GRect::~CL_GRect()
{

}


bool CL_GRect::isEmpty() const
{
  return ( upperLeft_ == lowerRight_);
}

bool CL_GRect::isValid() const
{
  return (lowerRight() >= upperLeft());
}

bool CL_GRect::contains(const CL_GPoint &p) const
{
  return (p >= upperLeft()) && (p < lowerRight());

}

bool CL_GRect::contains(const CL_GRect &r) const
{
  return contains(r.upperLeft()) && contains(r.lowerRight());
}

void CL_GRect::translate(int dx, int dy)
{
  upperLeft_.x += dx;
  upperLeft_.y += dy;
  lowerRight_.x += dx;
  lowerRight_.y += dy;
}

void CL_GRect::warp(const CL_GPoint &newUpperLeft)
{

  CL_GPoint delta = upperLeft_ - newUpperLeft;
  
  upperLeft_ -= delta;
  lowerRight_ -= delta;
  
}

void CL_GRect::resize(int w, int h)
{
  lowerRight_ = upperLeft_+CL_GPoint(w,h);
}


CL_GRect CL_GRect::unite(const CL_GRect &r) const
{
  CL_GPoint ul(0,0);
  CL_GPoint lr(-1, -1);

  if(r.isValid() && isValid())
    {
      r.upperLeft().x < upperLeft().x ?
	ul.x = r.upperLeft().x :
	ul.x = upperLeft().x;
      
      r.upperLeft().y < upperLeft().y ?
	ul.y = r.upperLeft().y :
	ul.y = upperLeft().y;
      
      r.lowerRight().x > lowerRight().x ?
	lr.x = r.lowerRight().x :
	lr.x = lowerRight().x;
      
      r.lowerRight().y > lowerRight().y ?
	lr.y = r.lowerRight().y :
	lr.y = lowerRight().y;
    }
  
  return CL_GRect(ul, lr);

}

CL_GRect CL_GRect::intersect(const CL_GRect &r) const
{
  CL_GPoint ul(0,0);
  CL_GPoint lr(-1, -1);
  CL_GRect rect;

  if(r.isValid() && isValid())
    {
      r.upperLeft().x > upperLeft().x ?
	ul.x = r.upperLeft().x :
	ul.x = upperLeft().x;
      
      r.upperLeft().y > upperLeft().y ?
	ul.y = r.upperLeft().y :
	ul.y = upperLeft().y;
      
      r.lowerRight().x < lowerRight().x ?
	lr.x = r.lowerRight().x :
	lr.x = lowerRight().x;
      
      r.lowerRight().y < lowerRight().y ?
	lr.y = r.lowerRight().y :
	lr.y = lowerRight().y;
    }

  if((ul.x == lr.x) || (ul.y == lr.y))
    {
      lr.x = -1;
      lr.y = -1;
      ul.x = 0;
      ul.y = 0;
    }

  return CL_GRect(ul, lr);
  
}

std::ostream& operator<<(std::ostream& s, const CL_GRect& p)
{
    s << "(" << p.upperLeft() << "," << p.lowerRight() << ")";
    return s;
}  
