/* tolua: error handling
** Support code for Lua bindings.
** Written by Waldemar Celes
** TeCGraf/PUC-Rio
** Jul 1998
** $Id: tolua_eh.c,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/

/* This code is free software; you can redistribute it and/or modify it. 
** The software provided hereunder is on an "as is" basis, and 
** the author has no obligation to provide maintenance, support, updates,
** enhancements, or modifications. 
*/

#include "tolua.h"
#include "tolua_eh.h"

#include <stdio.h>

/* variables to hold current error info */
static int err_narg;
static char* err_provided;
static char* err_expected;

void toluaI_eh_set (int narg, char* provided, char* expected)
{
 err_narg = narg;
 err_provided = provided;
 err_expected = expected;
}

void tolua_error (char* msg)
{
 if (msg[0]=='#' && err_narg!=0)
 {
  char buffer[256];
  if (msg[1]=='f')
   sprintf(buffer,"%s\n     argument #%d is '%s'; '%s' expected.\n",
           msg+2,err_narg,err_provided,err_expected);
  else if (msg[1]=='v')
   sprintf(buffer,"%s\n     value is '%s'; '%s' expected.\n",
           msg+2,err_provided,err_expected);
  lua_error(buffer);
 }
 else
  lua_error(msg);
}

void toluaI_eh_resetstate (void)
{
 err_narg = 0;
}
