/*
	$Id: mpeg_soundprovider.cpp,v 1.1.1.1 2000/04/09 12:18:03 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "API/MPEG/mpeg_soundprovider.h"
#include "API/Core/System/cl_assert.h"

CL_MPEGSoundProvider::CL_MPEGSoundProvider(const char *filename)
{
	file = filename;
}

CL_MPEGSoundProvider::~CL_MPEGSoundProvider()
{
}

CL_StreamSoundProvider_Session *CL_MPEGSoundProvider::begin_session()
{
	return new CL_MPEGSoundProvider_Session(file.c_str());
}

void CL_MPEGSoundProvider::end_session(CL_StreamSoundProvider_Session *session)
{
	delete session;
}

// -------------------------------------------------------------------------

CL_MPEGSoundProvider_Session::CL_MPEGSoundProvider_Session(const char *filename)
{
	Uint8 *m = NULL;
	int size = 0;
	mpeg = new MPEG(m, size, this);
	mpeg->EnableAudio(true);
}

CL_MPEGSoundProvider_Session::~CL_MPEGSoundProvider_Session()
{
	delete mpeg;
}

bool CL_MPEGSoundProvider_Session::eof() const
{
	return false; // bugbug: how do we figure this out?
}
	
void CL_MPEGSoundProvider_Session::stop()
{
	mpeg->Stop();
}

bool CL_MPEGSoundProvider_Session::play()
{
	mpeg->Play();
	return true;
}
		
bool CL_MPEGSoundProvider_Session::set_position(int pos)
{
	return false; // how to implement this?
}
	
int CL_MPEGSoundProvider_Session::get_data(void *data_ptr, int data_requested)
{
	audiospec.callback(audiospec.userdata, (Uint8 *) data_ptr, data_requested);
	return data_requested;
}

int CL_MPEGSoundProvider_Session::get_frequency() const
{
	return audiospec.freq;
}

SoundFormat CL_MPEGSoundProvider_Session::get_format() const
{
	if (audiospec.channels == 1)
	{
		if ((audiospec.format & MPEG_AUDIO_S8) == MPEG_AUDIO_S8) return sf_8bit_signed;
		if ((audiospec.format & MPEG_AUDIO_S16LSB) == MPEG_AUDIO_S16LSB) return sf_16bit_signed;
	}
	else if (audiospec.channels == 2)
	{
		if ((audiospec.format & MPEG_AUDIO_S8) == MPEG_AUDIO_S8) return sf_8bit_signed_stereo;
		if ((audiospec.format & MPEG_AUDIO_S16LSB) == MPEG_AUDIO_S16LSB) return sf_16bit_signed_stereo;
	}
	
	// damn, unknown sound format. something went wrong.
	cl_assert(false);
	return sf_8bit_signed;
}

// MPEGAudioDrv interface:

bool CL_MPEGSoundProvider_Session::Open(MPEGAudioSpec *desired, MPEGAudioSpec *optained)
{
	audiospec = *desired;
	*optained = audiospec;
	return true;
}

void CL_MPEGSoundProvider_Session::Close()
{
}

void CL_MPEGSoundProvider_Session::Pause(bool enable)
{
	// hmm, what is this supposed to do?
}

void CL_MPEGSoundProvider_Session::Mix(Uint8 *dst, Uint8 *src, Uint32 len, int volume)
{
	memcpy(dst, src, len);
}

void CL_MPEGSoundProvider_Session::Lock()
{
}

void CL_MPEGSoundProvider_Session::Unlock()
{
}

int CL_MPEGSoundProvider_Session::GetMaxVolume()
{
	return 100;
}

char *CL_MPEGSoundProvider_Session::GetError()
{
	return "No error";
}
