use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
DO :1 <- #?7
DO :2 <- ?#15
PLEASE DO :3 <- ?#253
DO READ OUT :1
DO READ OUT :2
PLEASE READ OUT :3
PLEASE DO :3 <- #?245
PLEASE READ OUT :3
DO :4 <- #3$#5
DO READ OUT :4
DO :5 <- :4$:4
DO READ OUT :5
DO ;1 <- #2
DO ,1 <- #1
PLEASE WRITE IN ;1 + ,1
DO READ OUT ;1 SUB #1 + ;1 SUB #2 + ,1 SUB #1
PLEASE ;1 SUB #1 <- #122
DO ;1 SUB #2 <- #64
DO ,1 SUB #1 <- #128
DO READ OUT ;1 + ,1
DO GIVE UP
';

print "1..78\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0', 'parser=Cintercal';

my @foo;
my $faa;
my $data = 'abcdef';

compile Language::INTERCAL 'prog', $prog;
@foo= ();
$faa = $data;
eval { prog(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 11 ? "" : "not ", "ok 2\n";
print "xxxiiDCCLXXII\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "xxxiiDCCLXXVI\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "xxxiiDCCCIC\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "xxxiiCMXI\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "XXVII\n" eq (shift @foo) ? "" : "not ", "ok 7\n";
print "CMLXXV\n" eq (shift @foo) ? "" : "not ", "ok 8\n";
print "XCVII\n" eq (shift @foo) ? "" : "not ", "ok 9\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 10\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 11\n";
print "ab" eq (shift @foo) ? "" : "not ", "ok 12\n";
print "c" eq (shift @foo) ? "" : "not ", "ok 13\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
$faa = $data;
eval { prog_o(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 14\n";
print @foo == 11 ? "" : "not ", "ok 15\n";
print "xxxiiDCCLXXII\n" eq (shift @foo) ? "" : "not ", "ok 16\n";
print "xxxiiDCCLXXVI\n" eq (shift @foo) ? "" : "not ", "ok 17\n";
print "xxxiiDCCCIC\n" eq (shift @foo) ? "" : "not ", "ok 18\n";
print "xxxiiCMXI\n" eq (shift @foo) ? "" : "not ", "ok 19\n";
print "XXVII\n" eq (shift @foo) ? "" : "not ", "ok 20\n";
print "CMLXXV\n" eq (shift @foo) ? "" : "not ", "ok 21\n";
print "XCVII\n" eq (shift @foo) ? "" : "not ", "ok 22\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 24\n";
print "ab" eq (shift @foo) ? "" : "not ", "ok 25\n";
print "c" eq (shift @foo) ? "" : "not ", "ok 26\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
$faa = $data;
eval { prog_q(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 27\n";
print @foo == 11 ? "" : "not ", "ok 28\n";
print "xxxiiDCCLXXII\n" eq (shift @foo) ? "" : "not ", "ok 29\n";
print "xxxiiDCCLXXVI\n" eq (shift @foo) ? "" : "not ", "ok 30\n";
print "xxxiiDCCCIC\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "xxxiiCMXI\n" eq (shift @foo) ? "" : "not ", "ok 32\n";
print "XXVII\n" eq (shift @foo) ? "" : "not ", "ok 33\n";
print "CMLXXV\n" eq (shift @foo) ? "" : "not ", "ok 34\n";
print "XCVII\n" eq (shift @foo) ? "" : "not ", "ok 35\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 36\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 37\n";
print "ab" eq (shift @foo) ? "" : "not ", "ok 38\n";
print "c" eq (shift @foo) ? "" : "not ", "ok 39\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
$faa = $data;
eval { prog_p(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 40\n";
print @foo == 11 ? "" : "not ", "ok 41\n";
print "xxxiiDCCLXXII\n" eq (shift @foo) ? "" : "not ", "ok 42\n";
print "xxxiiDCCLXXVI\n" eq (shift @foo) ? "" : "not ", "ok 43\n";
print "xxxiiDCCCIC\n" eq (shift @foo) ? "" : "not ", "ok 44\n";
print "xxxiiCMXI\n" eq (shift @foo) ? "" : "not ", "ok 45\n";
print "XXVII\n" eq (shift @foo) ? "" : "not ", "ok 46\n";
print "CMLXXV\n" eq (shift @foo) ? "" : "not ", "ok 47\n";
print "XCVII\n" eq (shift @foo) ? "" : "not ", "ok 48\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 49\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 50\n";
print "ab" eq (shift @foo) ? "" : "not ", "ok 51\n";
print "c" eq (shift @foo) ? "" : "not ", "ok 52\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
$faa = $data;
eval { prog_qp(\&faa, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 53\n";
print @foo == 11 ? "" : "not ", "ok 54\n";
print "xxxiiDCCLXXII\n" eq (shift @foo) ? "" : "not ", "ok 55\n";
print "xxxiiDCCLXXVI\n" eq (shift @foo) ? "" : "not ", "ok 56\n";
print "xxxiiDCCCIC\n" eq (shift @foo) ? "" : "not ", "ok 57\n";
print "xxxiiCMXI\n" eq (shift @foo) ? "" : "not ", "ok 58\n";
print "XXVII\n" eq (shift @foo) ? "" : "not ", "ok 59\n";
print "CMLXXV\n" eq (shift @foo) ? "" : "not ", "ok 60\n";
print "XCVII\n" eq (shift @foo) ? "" : "not ", "ok 61\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 62\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 63\n";
print "ab" eq (shift @foo) ? "" : "not ", "ok 64\n";
print "c" eq (shift @foo) ? "" : "not ", "ok 65\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo= ();
$faa = $data;
_run_db(prog_d(\&faa, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 66\n";
print @foo == 11 ? "" : "not ", "ok 67\n";
print "xxxiiDCCLXXII\n" eq (shift @foo) ? "" : "not ", "ok 68\n";
print "xxxiiDCCLXXVI\n" eq (shift @foo) ? "" : "not ", "ok 69\n";
print "xxxiiDCCCIC\n" eq (shift @foo) ? "" : "not ", "ok 70\n";
print "xxxiiCMXI\n" eq (shift @foo) ? "" : "not ", "ok 71\n";
print "XXVII\n" eq (shift @foo) ? "" : "not ", "ok 72\n";
print "CMLXXV\n" eq (shift @foo) ? "" : "not ", "ok 73\n";
print "XCVII\n" eq (shift @foo) ? "" : "not ", "ok 74\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 75\n";
print "I\n" eq (shift @foo) ? "" : "not ", "ok 76\n";
print "ab" eq (shift @foo) ? "" : "not ", "ok 77\n";
print "c" eq (shift @foo) ? "" : "not ", "ok 78\n";

sub foo {
    push @foo, join('', @_);
}

sub faa {
    my $t;
    if (@_) {
	$t = substr($faa, 0, $_[0]);
	$faa = substr($faa, $_[0]);
    } else {
	$t = $faa;
	$faa = '';
    }
    $t;
}

