package Language::INTERCAL::Interface::None;

# pseudo user interface which never enters interactive mode

# This file is part of CLC-INTERCAL

# Copyright (c) 2006 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use strict;
use vars qw($PERVERSION);
$PERVERSION = "CLC-INTERCAL INTERCAL/Interface/None.pm 1.-94.-4";

use Carp;

use Language::INTERCAL::Exporter '1.-94.-4';

sub new {
    @_ == 1 or croak "Usage: Language::INTERCAL::Interface::None->new";
    my ($class) = @_;
    # I bet you never saw an object implemented as blessed regular expression
    bless qr/^/, $class;
}

sub is_interactive { 0 }

sub run {
    croak "Non interactive interface should never enter run()";
}

sub start {
    croak "Non interactive interface should never enter start()";
}

1;
