dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2008 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Richard B. Kreckel.

AC_PREREQ(2.13)

dnl Is the gmp header file new enough? (should be implemented with an argument)
AC_DEFUN([CL_GMP_H_VERSION],
[AC_CACHE_CHECK([for recent enough gmp.h], cl_cv_new_gmp_h, [
  AC_TRY_CPP([#include <gmp.h>
#if !defined(__GNU_MP_VERSION) || (__GNU_MP_VERSION < 3)
 #error "ancient gmp.h"
#endif],
cl_cv_new_gmp_h="yes", cl_cv_new_gmp_h="no")
])])dnl

dnl Does libgmp provide some functionality introduced in version 3.0?
AC_DEFUN([CL_GMP_CHECK],
[AC_CACHE_CHECK([for working libgmp], cl_cv_new_libgmp, [
    SAVELIBS=$LIBS
    LIBS="$LIBS -lgmp"
    AC_TRY_LINK([#include <gmp.h>],[mpn_divexact_by3(0,0,0)],
cl_cv_new_libgmp="yes", cl_cv_new_libgmp="no")
    LIBS=$SAVELIBS])
    if test "$cl_cv_new_libgmp" = yes; then
      LIBS="$LIBS -lgmp"
    fi
])

dnl What is sizeof(mp_limb_t)?  (It has to match sizeof(uintD) later.)
AC_DEFUN([CL_GMP_SET_UINTD],
[AC_CACHE_CHECK([how large gmp demands uintD to be], cl_cv_gmp_set_uintd, [
    AC_TRY_RUN([#include <gmp.h>
#include <stdio.h>
int main() {
    FILE *f=fopen("conftestval", "w");
    if (!f) return(255);
    if (sizeof(mp_limb_t) > sizeof(long))
        fprintf(f, "long long");
    else if (sizeof(mp_limb_t) == sizeof(long))
        fprintf(f, "long");
    else if (sizeof(mp_limb_t) == sizeof(int))
        fprintf(f, "int");
    else return(sizeof(mp_limb_t));
#if defined(__GMP_BITS_PER_MP_LIMB)
    /* Is there a nail in a limb? */
    if (8*sizeof(mp_limb_t)!=__GMP_BITS_PER_MP_LIMB)
        return(254);
#endif
    return(0);
}], cl_cv_gmp_set_uintd=`cat conftestval`
    cl_gmp_demands="GMP_DEMANDS_UINTD_`echo ${cl_cv_gmp_set_uintd} | sed -e 'y/ gilnot/_GILNOT/'`",
    gmp_retval="$ac_status"
    if test x$gmp_retval = "x255"; then AC_MSG_ERROR([error opening output file.]); fi
    if test x$gmp_retval = "x254"; then AC_MSG_ERROR([nails in MP limbs are unsupported.]); fi
    AC_MSG_ERROR([Don't know which C-type has sizeof $gmp_retval.]),
    AC_MSG_ERROR([cross-compiling - cannot determine]))
])
AC_DEFINE_UNQUOTED($cl_gmp_demands)
])

dnl Whether or not to use GMP. Sets CL_USE_GMP.
dnl Also sets CPPFLAGS, LDFLAGS if --with-gmp=DIR was specified.
AC_DEFUN([CL_LIBGMP],
[AC_ARG_WITH(gmp, AS_HELP_STRING([--with-gmp@<:@=DIR@:>@],
  [use external low-level functions from GNU MP (installed in prefix DIR) @<:@default=yes@:>@.]),[
    with_gmp="$withval"
  ],
  with_gmp="yes")
case $with_gmp in
  yes)
    dnl --with-gmp
    CL_GMP_H_VERSION
    if test "$cl_cv_new_gmp_h" = yes; then
      CL_GMP_CHECK
      if test "$cl_cv_new_libgmp" = yes; then
        CL_GMP_SET_UINTD
        AC_DEFINE(CL_USE_GMP, 1, [Define if GNU MP library is available])
      else
        AC_MSG_WARN([The GNU MP library is too old to be used.])
      fi
    else
      AC_MSG_WARN([The header file <gmp.h> is too old to be used.])
    fi
  ;;
  no)
    dnl --without-gmp
  ;;
  *)
    dnl --with-gmp=DIR
    case $withval in
      [[\\/$]]* | ?:[[\\/]]* )
      ;;
      *) AC_MSG_ERROR([expected an absolute directory name for --with-gmp: $withval])
      ;;
    esac
    saved_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS -I${withval}/include"
    saved_LDFLAGS="$LDFLAGS"
    LDFLAGS="$LDFLAGS -L${withval}/lib"
    AC_LIB_LINKFLAGS_FROM_LIBS([GMP_RPATH_CFG], [$LDFLAGS])
    LDFLAGS="$GMP_RPATH_CFG $LDFLAGS"
    AC_MSG_NOTICE([Using "\"$LDFLAGS\"" rpath to link with GMP])
    CL_GMP_H_VERSION
    if test "$cl_cv_new_gmp_h" = yes; then
      CL_GMP_CHECK
      if test "$cl_cv_new_libgmp" = yes; then
        CL_GMP_SET_UINTD
        AC_DEFINE(CL_USE_GMP)
      else
        AC_MSG_WARN([The GNU MP library is too old to be used.])
        CPPFLAGS="$saved_CPPFLAGS"
        LDFLAGS="$saved_LDFLAGS"
      fi
    else
      AC_MSG_WARN([The header file <gmp.h> is too old to be used.])
      CPPFLAGS="$saved_CPPFLAGS"
      LDFLAGS="$saved_LDFLAGS"
    fi
  ;;
esac
])
