
type pos = { current_element : string;
	     file :string ;
	     line : int;
	     col : int;
	     line_end : int;
	     col_end : int; }

type param_type =
    Pos of pos list
  | Str of string
  | Type of Ast_c.fullType
  | Init of Ast_c.initialiser
  | Int of int
  | Param of Ast_c.parameterType
  | ParamList of Ast_c.parameterType Ast_c.wrap2 list
  | Expr of Ast_c.expression
  | ExprList of Ast_c.argument Ast_c.wrap2 list
  | Stmt of Ast_c.statement

val fcts : (string, param_type list -> unit) Hashtbl.t

(* ---------------------------------------------------------------------- *)
(* Match management *)

val inc_match : bool ref
val include_match : bool -> unit
val dir : unit -> string
