/*
 * This file is part of the Colobot: Gold Edition source code
 * Copyright (C) 2001-2014, Daniel Roux, EPSITEC SA & TerranovaTeam
 * http://epsiteс.ch; http://colobot.info; http://github.com/colobot
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://gnu.org/licenses
 */

#include "object/level/parserexceptions.h"


#include "object/level/parser.h"

#include <boost/lexical_cast.hpp>

CLevelParserException::CLevelParserException(std::string message) NOEXCEPT
{
    m_message = message;
}

const char* CLevelParserException::what() const NOEXCEPT
{
    return m_message.c_str();
}

CLevelParserExceptionMissingParam::CLevelParserExceptionMissingParam(CLevelParserParam* thisParam) NOEXCEPT
: CLevelParserException("Missing required param "+thisParam->GetName()+" (in "+thisParam->GetLine()->GetLevel()->GetFilename()+":"+boost::lexical_cast<std::string>(thisParam->GetLine()->GetLineNumber())+")")
{
}

CLevelParserExceptionBadParam::CLevelParserExceptionBadParam(CLevelParserParam* thisParam, std::string requestedType) NOEXCEPT
: CLevelParserException("Unable to parse '"+thisParam->GetValue()+"' as "+requestedType+" (param '"+thisParam->GetName()+"' in "+thisParam->GetLine()->GetLevel()->GetFilename()+":"+boost::lexical_cast<std::string>(thisParam->GetLine()->GetLineNumber())+")")
{
}
