/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private File lockFile = null;
    private FileWriter writer = null;
    private boolean append = false;
    static /* synthetic */ Class class$org$apache$commons$io$output$LockableFileWriter;

    public LockableFileWriter(String fileName) throws IOException {
        this(fileName, false, null);
    }

    public LockableFileWriter(String fileName, boolean append) throws IOException {
        this(fileName, append, null);
    }

    public LockableFileWriter(String fileName, boolean append, String lockDir) throws IOException {
        this(new File(fileName), append, lockDir);
    }

    public LockableFileWriter(File file) throws IOException {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean append) throws IOException {
        this(file, append, null);
    }

    public LockableFileWriter(File file, boolean append, String lockDir) throws IOException {
        this.append = append;
        if (lockDir == null) {
            lockDir = System.getProperty("java.io.tmpdir");
        }
        this.testLockDir(new File(lockDir));
        this.lockFile = new File(lockDir, file.getName() + LCK);
        this.createLock();
        this.writer = new FileWriter(file.getAbsolutePath(), this.append);
    }

    private void testLockDir(File lockDir) throws IOException {
        if (!lockDir.exists()) {
            throw new IOException("Could not find lockDir: " + lockDir.getAbsolutePath());
        }
        if (!lockDir.canWrite()) {
            throw new IOException("Could not write to lockDir: " + lockDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLock() throws IOException {
        Class clazz = class$org$apache$commons$io$output$LockableFileWriter == null ? (class$org$apache$commons$io$output$LockableFileWriter = LockableFileWriter.class$("org.apache.commons.io.output.LockableFileWriter")) : class$org$apache$commons$io$output$LockableFileWriter;
        synchronized (clazz) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        finally {
            this.lockFile.delete();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

