/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      ModemView : NSObject <PrefsViewProtocol>
 *
 *  Description:  Modem preferences (device, speed, flow control etc.)
 */

#import <AppKit/NSView.h>
#import <AppKit/NSBox.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSPopUpButton.h>

#import "Modem.h"

@implementation ModemView

- (id) initWithPrefs: (NSMutableDictionary *) sessionPrefs
{
  NSView *hardwareFrameView;
  NSView *dataFrameView;
  NSView *advancedFrameView;

  [super init];
  
  if ((prefs = [sessionPrefs objectForKey: @"Modem"]) == nil)
  {
    [sessionPrefs 
      setObject: [NSMutableDictionary dictionary] forKey: @"Modem"];
    prefs = [sessionPrefs objectForKey: @"Modem"];
  }

  view = [[NSView alloc] initWithFrame: NSMakeRect (10, 44, 280, 393)];

  // Hardware -------------------------------------------------- 
  hardwareFrame = [[NSBox alloc] initWithFrame: 
    NSMakeRect (0, 290, 280, 100)];
  [hardwareFrame setTitle: @"Hardware"];
  [view addSubview: hardwareFrame];
  hardwareFrameView = [hardwareFrame contentView];

  // Device
  deviceLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 52, 83, 21)];
  [deviceLabel setAlignment: NSRightTextAlignment];
  [deviceLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [deviceLabel setSelectable: NO];
  [deviceLabel setEditable: NO];
  [deviceLabel setBezeled: NO];
  [deviceLabel setBordered: NO];
  [deviceLabel setStringValue: @"Device:"];
  [hardwareFrameView addSubview: deviceLabel];

  devicePop = [[NSPopUpButton alloc] initWithFrame:
    NSMakeRect (88, 52, 160, 21)];
  [devicePop setAutoenablesItems: NO];
  [devicePop addItemWithTitle:@"/dev/modem"];
  [devicePop addItemWithTitle:@"/dev/ttyS0"];
  [devicePop addItemWithTitle:@"/dev/ttyS1"];
  [devicePop addItemWithTitle:@"/dev/ttyS2"];
  [devicePop addItemWithTitle:@"/dev/ttyS3"];
  [hardwareFrameView addSubview: devicePop];

  // Speed
  speedLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 26, 83, 21)];
  [speedLabel setAlignment: NSRightTextAlignment];
  [speedLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [speedLabel setSelectable: NO];
  [speedLabel setEditable: NO];
  [speedLabel setBezeled: NO];
  [speedLabel setBordered: NO];
  [speedLabel setStringValue: @"Speed:"];
  [hardwareFrameView addSubview: speedLabel];

  speedPop = [[NSPopUpButton alloc] initWithFrame:
    NSMakeRect (88, 26, 160, 21)];
  [speedPop setAutoenablesItems: NO];
  [speedPop addItemWithTitle:@"2400"];
  [speedPop addItemWithTitle:@"9600"];
  [speedPop addItemWithTitle:@"19200"];
  [speedPop addItemWithTitle:@"38400"];
  [speedPop addItemWithTitle:@"57600"];
  [speedPop addItemWithTitle:@"115200"];
  [speedPop addItemWithTitle:@"230400"];
  [speedPop addItemWithTitle:@"460800"];
  [hardwareFrameView addSubview: speedPop];

  // Flow control
  flowLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 1, 83, 21)];
  [flowLabel setAlignment: NSRightTextAlignment];
  [flowLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [flowLabel setSelectable: NO];
  [flowLabel setEditable: NO];
  [flowLabel setBezeled: NO];
  [flowLabel setBordered: NO];
  [flowLabel setStringValue: @"Flow control:"];
  [hardwareFrameView addSubview: flowLabel];

  /*- crtscts 
    - nocrtscts
    - cdtrcts
    - nocdtrcts
    - xonxoff
    */
  flowPop = [[NSPopUpButton alloc] initWithFrame:
    NSMakeRect (88, 1, 160, 21)];
  [flowPop setAutoenablesItems: NO];
  [flowPop addItemWithTitle: @"CRTS/CTS (Hardware)"];
  [flowPop addItemWithTitle: @"CDTR/CTS (Hardware)"];
  [flowPop addItemWithTitle: @"XON/XOFF (Software)"];
  [flowPop addItemWithTitle: @"Leave unchanged"];
  [hardwareFrameView addSubview: flowPop];

  // Data packets -------------------------------------------------- 
  dataFrame = [[NSBox alloc] initWithFrame: 
    NSMakeRect (0, 184, 280, 103)];
  [dataFrame setTitle: @"Data packets"];
  [view addSubview: dataFrame];
  dataFrameView = [dataFrame contentView];

  defaultMRU = [[NSButton alloc] initWithFrame: 
    NSMakeRect (0, 52, 156, 21)];
  [defaultMRU setTitle: @"Default MRU and MTU"];
  [defaultMRU setButtonType: NSSwitchButton];
  [defaultMRU setImagePosition: NSImageRight];
  [defaultMRU setAction: @selector (defaultMRUAction:)];
  [defaultMRU setTarget: self];
  [dataFrameView addSubview: defaultMRU];

  // MRU
  mruLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 26, 135, 21)];
  [mruLabel setAlignment: NSRightTextAlignment];
  [mruLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [mruLabel setSelectable: NO];
  [mruLabel setEditable: NO];
  [mruLabel setBezeled: NO];
  [mruLabel setBordered: NO];
  [mruLabel setStringValue: @"Maximum Receive Unit:"];
  [dataFrameView addSubview: mruLabel];
  
  mruTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (140, 26, 56, 21)];
  [dataFrameView addSubview: mruTF];

  // MTU
  mtuLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 0, 135, 21)];
  [mtuLabel setAlignment: NSRightTextAlignment];
  [mtuLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [mtuLabel setSelectable: NO];
  [mtuLabel setEditable: NO];
  [mtuLabel setBezeled: NO];
  [mtuLabel setBordered: NO];
  [mtuLabel setStringValue: @"Maximum Transfer Unit:"];
  [dataFrameView addSubview: mtuLabel];
  
  mtuTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (140, 0, 56, 21)];
  [dataFrameView addSubview: mtuTF];

  // Linking MRU and MTU textfields
  [mruTF setNextText: mtuTF];
  [mtuTF setNextText: mruTF];

  // Advanced options -------------------------------------------------- 
  advancedFrame = [[NSBox alloc] initWithFrame: 
    NSMakeRect (0, 104, 280, 77)];
  [advancedFrame setTitle: @"Advanced options"];
  [view addSubview: advancedFrame];
  advancedFrameView = [advancedFrame contentView];

  escapeLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 27, 108, 21)];
  [escapeLabel setAlignment: NSRightTextAlignment];
  [escapeLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [escapeLabel setSelectable: NO];
  [escapeLabel setEditable: NO];
  [escapeLabel setBezeled: NO];
  [escapeLabel setBordered: NO];
  [escapeLabel setStringValue: @"Escape characters:"];
  [advancedFrameView addSubview: escapeLabel];
  
  escapeTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (113, 27, 151, 21)];
  [advancedFrameView addSubview: escapeTF];

  asyncmapLabel = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (0, 4, 108, 21)];
  [asyncmapLabel setAlignment: NSRightTextAlignment];
  [asyncmapLabel setBackgroundColor: [NSColor windowBackgroundColor]];
  [asyncmapLabel setSelectable: NO];
  [asyncmapLabel setEditable: NO];
  [asyncmapLabel setBezeled: NO];
  [asyncmapLabel setBordered: NO];
  [asyncmapLabel setStringValue: @"Async charmap:"];
  [advancedFrameView addSubview: asyncmapLabel];
  
  asyncmapTF = [[NSTextField alloc] initWithFrame: 
    NSMakeRect (113, 4, 151, 21)];
  [advancedFrameView addSubview: asyncmapTF];

  // Linking escapeTF and asyncmapTF
  [escapeTF setNextText: asyncmapTF];
  [asyncmapTF setNextText: escapeTF];

  RELEASE (speedLabel);
  RELEASE (speedPop);
  RELEASE (deviceLabel);
  RELEASE (devicePop);
  RELEASE (hardwareFrame);
  
  RELEASE (mruLabel);
  RELEASE (mruTF);
  RELEASE (mtuLabel);
  RELEASE (mtuTF);
  RELEASE (dataFrame);

  RELEASE (escapeLabel);
  RELEASE (escapeTF);
  RELEASE (asyncmapLabel);
  RELEASE (asyncmapTF);
  RELEASE (advancedFrame);

  // load settings or set defaults
  [self setDefaults];

  return self;
}

// dealloc never called for array memebers
- (void) release
{
  NSLog (@"ModemView: release (%i)", [view retainCount]);
  if ([view superview])
  {
    [view removeFromSuperview];
  }
  else
  {
    RELEASE (view);
  }

  [super dealloc];
}

/*-------------------------------------------------------------------------*
 *  Protocol methods
 *-------------------------------------------------------------------------*/
- (id) show: (id)superView
{
  [superView addSubview: view];
  RELEASE (view);

  return nil;
}

- (void) hide 
{
  RETAIN (view);
  [view removeFromSuperview];
}

- (void) setDefaults
{
  if ([prefs count] > 0)
  {
    [devicePop selectItemWithTitle: [prefs objectForKey: @"Device"]];
    [speedPop selectItemWithTitle: [prefs objectForKey: @"Speed"]];
    [flowPop selectItemWithTitle: [prefs objectForKey: @"FlowControl"]];
    if ([[prefs objectForKey: @"DefaultMRUAndMTU"] isEqualToString: @"YES"])
    {
      [defaultMRU setState: NSOnState];
    }
    else
    {
      [defaultMRU setState: NSOffState];
    }
    [mruTF setStringValue: [prefs objectForKey: @"MRU"]];
    [mtuTF setStringValue: [prefs objectForKey: @"MTU"]];
    [escapeTF setStringValue: [prefs objectForKey: @"EscapeChars"]];
    [asyncmapTF setStringValue: [prefs objectForKey: @"AsyncCharmap"]];

  }
  else
  {
    [devicePop selectItemWithTitle: @"/dev/modem"];
    [speedPop selectItemWithTitle: @"115200"];
    [flowPop selectItemWithTitle: @"Hardware [CRTS/CTS]"];

    [mruTF setStringValue: @"1500"];
    [mtuTF setStringValue: @"1500"];
    [defaultMRU setState: NSOnState];
  }
  [self defaultMRUAction: self];
}

- (NSMutableDictionary *) prefsDict
{
  NSMutableString *isDefaultMRU;
 
  isDefaultMRU = [NSMutableString stringWithString: @"YES"];

  [prefs setObject: [devicePop titleOfSelectedItem] forKey: @"Device"];
  [prefs setObject: [speedPop titleOfSelectedItem] forKey: @"Speed"];
  [prefs setObject: [flowPop titleOfSelectedItem] forKey: @"FlowControl"];

  if ([defaultMRU state] == NSOffState) [isDefaultMRU setString: @"NO"];
  [prefs setObject: isDefaultMRU forKey: @"DefaultMRUAndMTU"];

  [prefs setObject: [mruTF stringValue] forKey: @"MRU"];
  [prefs setObject: [mtuTF stringValue] forKey: @"MTU"];
  [prefs setObject: [escapeTF stringValue] forKey: @"EscapeChars"];
  [prefs setObject: [asyncmapTF stringValue] forKey: @"AsyncCharmap"];

  return prefs;
}

/*-------------------------------------------------------------------------*
 *  Controls' action methods
 *-------------------------------------------------------------------------*/
- (void) defaultMRUAction: (id)sender
{
  if ([defaultMRU intValue])
  {
    [mruLabel setTextColor: [NSColor darkGrayColor]];
    [mruTF setEditable: NO];
    [mruTF setSelectable: NO];
    [mruTF setTextColor: [NSColor darkGrayColor]];

    [mtuLabel setTextColor: [NSColor darkGrayColor]];
    [mtuTF setEditable: NO];
    [mtuTF setSelectable: NO];
    [mtuTF setTextColor: [NSColor darkGrayColor]];
  }
  else
  {
    [mruLabel setTextColor: [NSColor blackColor]];
    [mruTF setEditable: YES];
    [mruTF setSelectable: YES];
    [mruTF setTextColor: [NSColor blackColor]];

    [mtuLabel setTextColor: [NSColor blackColor]];
    [mtuTF setEditable: YES];
    [mtuTF setSelectable: YES];
    [mtuTF setTextColor: [NSColor blackColor]];
  }

  [mruLabel setNeedsDisplay];
  [mruTF setNeedsDisplay];
  [mtuLabel setNeedsDisplay];
  [mtuTF setNeedsDisplay];
}

@end
