# Compose ISO-8859-1 characters following vim's digraphs
# (based on the "Default digraphs on non-MS-DOS, non-Win32 machines" table
# (":help digraph_table") of vim 4.6.
# To follow vim's behaviour, we need to give each combination twice
# (both char1 char2 and char2 char1) (":help i_digraph": "If a digraph with
# {char1}{char2} does not exist, a digraph {char2}{char1} is searched for.
# This will help when you don't remember which character comes first.")
#
# By J.H.M.Dassen <jdassen@wi.leidenuniv.nl>
#
compose ' ' ' ' to ' ' # 160 NO-BREAK SPACE (not a vim digraph)
compose '!' '~' to '' # 161 INVERTED EXCLAMATION MARK
compose '~' '!' to '' # 161
compose 'c' '|' to '' # 162 CENT SIGN
compose '|' 'c' to '' # 162
compose '$' '$' to '' # 163 POUND SIGN
compose 'o' 'x' to '' # 164 CURRENCY SIGN
compose 'x' 'o' to '' # 164
compose '-' 'Y' to '' # 165 YEN SIGN
compose 'Y' '-' to '' # 165
compose '|' '|' to '' # 166 BROKEN BAR
compose 'a' 'p' to '' # 167 SECTION SIGN
compose 'p' 'a' to '' # 167
compose '"' '"' to '' # 168 DIAERESIS
compose 'O' 'c' to '' # 169 COPYRIGHT SIGN
compose 'c' 'O' to '' # 169
compose '-' 'a' to '' # 170 FEMININE ORDINAL INDICATOR
compose 'a' '-' to '' # 170
compose '<' '<' to '' # 171 LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
compose ',' '-' to '' # 172 NOT SIGN
compose '-' ',' to '' # 172
compose '-' '-' to '' # 173 SOFT HYPHEN
compose 'O' 'r' to '' # 174 REGISTERED SIGN
compose 'r' 'O' to '' # 174
compose '-' '=' to '' # 175 MACRON
compose '=' '-' to '' # 175
compose '~' 'o' to '' # 176 DEGREE SIGN
compose '+' '-' to '' # 177 PLUS-MINUS SIGN
compose '-' '+' to '' # 177
compose '2' '2' to '' # 178 SUPERSCRIPT TWO
compose '3' '3' to '' # 179 SUPERSCRIPT THREE
compose ''' ''' to '' # 180 ACUTE ACCENT
compose 'j' 'u' to '' # 181 MICRO SIGN
compose 'u' 'j' to '' # 181
compose 'p' 'p' to '' # 182 PILCROW SIGN
compose '.' '~' to '' # 183 MIDDLE DOT
compose '~' '.' to '' # 183
compose ',' ',' to '' # 184 CEDILLA
compose '1' '1' to '' # 185 SUPERSCRIPT ONE
compose '-' 'o' to '' # 186 MASCULINE ORDINAL INDICATOR
compose 'o' '-' to '' # 186
compose '>' '>' to '' # 187 RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
compose '1' '4' to '' # 188 VULGAR FRACTION ONE QUARTER
compose '4' '1' to '' # 188
compose '1' '2' to '' # 189 VULGAR FRACTION ONE HALF
compose '2' '1' to '' # 189
compose '3' '4' to '' # 190 VULGAR FRACTION THREE QUARTERS
compose '4' '3' to '' # 190
compose '?' '~' to '' # 191 INVERTED QUESTION MARK
compose '~' '?' to '' # 191
compose 'A' '`' to '' # 192 LATIN CAPITAL LETTER A WITH GRAVE
compose '`' 'A' to '' # 192
compose ''' 'A' to '' # 193 LATIN CAPITAL LETTER A WITH ACUTE
compose 'A' ''' to '' # 193
compose 'A' '^' to '' # 194 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
compose '^' 'A' to '' # 194
compose 'A' '~' to '' # 195 LATIN CAPITAL LETTER A WITH TILDE
compose '~' 'A' to '' # 195
compose '"' 'A' to '' # 196 LATIN CAPITAL LETTER A WITH DIAERESIS
compose 'A' '"' to '' # 196
compose '@' 'A' to '' # 197 LATIN CAPITAL LETTER A WITH RING ABOVE
compose 'A' '@' to '' # 197
compose 'A' 'E' to '' # 198 LATIN CAPITAL LIGATURE AE
compose 'E' 'A' to '' # 198
compose ',' 'C' to '' # 199 LATIN CAPITAL LETTER C WITH CEDILLA
compose 'C' ',' to '' # 199
compose 'E' '`' to '' # 200 LATIN CAPITAL LETTER E WITH GRAVE
compose '`' 'E' to '' # 200
compose ''' 'E' to '' # 201 LATIN CAPITAL LETTER E WITH ACUTE
compose 'E' ''' to '' # 201
compose 'E' '^' to '' # 202 LATIN CAPITAL LETTER E WITH CIRCUMFLEX
compose '^' 'E' to '' # 202
compose '"' 'E' to '' # 203 LATIN CAPITAL LETTER E WITH DIAERESIS
compose 'E' '"' to '' # 203
compose 'I' '`' to '' # 204 LATIN CAPITAL LETTER I WITH GRAVE
compose '`' 'I' to '' # 204
compose ''' 'I' to '' # 205 LATIN CAPITAL LETTER I WITH ACUTE
compose 'I' ''' to '' # 205
compose 'I' '^' to '' # 206 LATIN CAPITAL LETTER I WITH CIRCUMFLEX
compose '^' 'I' to '' # 206
compose '"' 'I' to '' # 207 LATIN CAPITAL LETTER I WITH DIAERESIS
compose 'I' '"' to '' # 207
compose '-' 'D' to '' # 208 LATIN CAPITAL LETTER ETH
compose 'D' '-' to '' # 208
compose 'N' '~' to '' # 209 LATIN CAPITAL LETTER N WITH TILDE
compose '~' 'N' to '' # 209
compose 'O' '`' to '' # 210 LATIN CAPITAL LETTER O WITH GRAVE
compose '`' 'O' to '' # 210
compose ''' 'O' to '' # 211 LATIN CAPITAL LETTER O WITH ACUTE
compose 'O' ''' to '' # 211
compose 'O' '^' to '' # 212 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
compose '^' 'O' to '' # 212
compose 'O' '~' to '' # 213 LATIN CAPITAL LETTER O WITH TILDE
compose '~' 'O' to '' # 213
compose '"' 'O' to '' # 214 LATIN CAPITAL LETTER O WITH DIAERESIS
compose 'O' '"' to '' # 214
compose '/' '\' to '' # 215 MULTIPLICATION SIGN
compose '\' '/' to '' # 215
compose '/' 'O' to '' # 216 LATIN CAPITAL LETTER O WITH STROKE
compose 'O' '/' to '' # 216
compose 'U' '`' to '' # 217 LATIN CAPITAL LETTER U WITH GRAVE
compose '`' 'U' to '' # 217
compose ''' 'U' to '' # 218 LATIN CAPITAL LETTER U WITH ACUTE
compose 'U' ''' to '' # 218
compose 'U' '^' to '' # 219 LATIN CAPITAL LETTER U WITH CIRCUMFLEX
compose '^' 'U' to '' # 219
compose '"' 'U' to '' # 220 LATIN CAPITAL LETTER U WITH DIAERESIS
compose 'U' '"' to '' # 220
compose ''' 'Y' to '' # 221 LATIN CAPITAL LETTER Y WITH ACUTE
compose 'Y' ''' to '' # 221
compose 'I' 'p' to '' # 222 LATIN CAPITAL LETTER THORN
compose 'p' 'I' to '' # 222
compose 's' 's' to '' # 223 LATIN SMALL LETTER SHARP S
compose '`' 'a' to '' # 224 LATIN SMALL LETTER A WITH GRAV
compose 'a' '`' to '' # 224
compose ''' 'a' to '' # 225 LATIN SMALL LETTER A WITH ACUTE
compose 'a' ''' to '' # 225
compose '^' 'a' to '' # 226 LATIN SMALL LETTER A WITH CIRCUMFLEX
compose 'a' '^' to '' # 226
compose 'a' '~' to '' # 227 LATIN SMALL LETTER A WITH TILDE
compose '~' 'a' to '' # 227
compose '"' 'a' to '' # 228 LATIN SMALL LETTER A WITH DIAERESIS
compose 'a' '"' to '' # 228
compose '@' 'a' to '' # 229 LATIN SMALL LETTER A WITH RING ABOVE
compose 'a' '@' to '' # 229
compose 'a' 'e' to '' # 230 LATIN SMALL LIGATURE AE
compose 'e' 'a' to '' # 230
compose ',' 'c' to '' # 231 LATIN SMALL LETTER C WITH CEDILLA
compose 'c' ',' to '' # 231
compose '`' 'e' to '' # 232 LATIN SMALL LETTER E WITH GRAVE
compose 'e' '`' to '' # 232
compose ''' 'e' to '' # 233 LATIN SMALL LETTER E WITH ACUTE
compose 'e' ''' to '' # 233
compose '^' 'e' to '' # 234 LATIN SMALL LETTER E WITH CIRCUMFLEX
compose 'e' '^' to '' # 234
compose '"' 'e' to '' # 235 LATIN SMALL LETTER E WITH DIAERESIS
compose 'e' '"' to '' # 235
compose '`' 'i' to '' # 236 LATIN SMALL LETTER I WITH GRAVE
compose 'i' '`' to '' # 236
compose ''' 'i' to '' # 237 LATIN SMALL LETTER I WITH ACUTE
compose 'i' ''' to '' # 237
compose '^' 'i' to '' # 238 LATIN SMALL LETTER I WITH CIRCUMFLEX
compose 'i' '^' to '' # 238
compose '"' 'i' to '' # 239 LATIN SMALL LETTER I WITH DIAERESIS
compose 'i' '"' to '' # 239
compose '-' 'd' to '' # 240 LATIN SMALL LETTER ETH
compose 'd' '-' to '' # 240
compose 'n' '~' to '' # 241 LATIN SMALL LETTER N WITH TILDE
compose '~' 'n' to '' # 241
compose '`' 'o' to '' # 242 LATIN SMALL LETTER O WITH GRAVE
compose 'o' '`' to '' # 242
compose ''' 'o' to '' # 243 LATIN SMALL LETTER O WITH ACUTE
compose 'o' ''' to '' # 243
compose '^' 'o' to '' # 244 LATIN SMALL LETTER O WITH CIRCUMFLEX
compose 'o' '^' to '' # 244
compose 'o' '~' to '' # 245 LATIN SMALL LETTER O WITH TILDE
compose '"' 'o' to '' # 246 LATIN SMALL LETTER O WITH DIAERESIS
compose 'o' '"' to '' # 246
compose '-' ':' to '' # 247 DIVISION SIGN
compose ':' '-' to '' # 247
compose '/' 'o' to '' # 248 LATIN SMALL LETTER O WITH STROKE
compose 'o' '/' to '' # 248
compose '`' 'u' to '' # 249 LATIN SMALL LETTER U WITH GRAVE
compose 'u' '`' to '' # 249
compose ''' 'u' to '' # 250 LATIN SMALL LETTER U WITH ACUTE
compose 'u' ''' to '' # 250
compose '^' 'u' to '' # 251 LATIN SMALL LETTER U WITH CIRCUMFLEX
compose 'u' '^' to '' # 251
compose '"' 'u' to '' # 252 LATIN SMALL LETTER U WITH DIAERESIS
compose 'u' '"' to '' # 252
compose ''' 'y' to '' # 253 LATIN SMALL LETTER Y WITH ACUTE
compose 'y' ''' to '' # 253
compose 'i' 'p' to '' # 254 LATIN SMALL LETTER THORN
compose 'p' 'i' to '' # 254
compose '"' 'y' to '' # 255 LATIN SMALL LETTER Y WITH DIAERESIS
compose 'y' '"' to '' # 255
#
## ^K introduces digraphs in vim.
#       control keycode  37 = Compose

