/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * strmap.c,v 1.6 1998/11/10 00:06:59 jenglish Exp
 *
 * Author: 	Joe English
 * Created: 	25 Feb 1995
 * Description: Associative arrays mapping strings to strings.
 *		Simple wrapper around CTries, providing storage
 * 		management for values.
 */

#include <stdlib.h>
#include <string.h>

#include "project.h"
#include "ctrie.h"
#include "strmap.h"

struct strmapRec
{
    CTrie map;
};

char *savestring(const char *p)	/* replacement for strdup */
{
    char *q = malloc(strlen(p) + 1);	/* %%% check */
    strcpy(q,p);
    return q;
}

strmap strmap_create(void)
{
    strmap m = malloc(sizeof(*m));
    m->map = ctrie_create();
    return m;
}
/*ARGSUSED*/
static void strmap_destroyproc(CTrieNode n, void *dummy)
{
    free(ctrie_getvalue(n));
}

void strmap_destroy(strmap m)
{
    ctrie_foreach(m->map, strmap_destroyproc, 0);
    ctrie_destroy(m->map);
    free(m);
}

void strmap_set(strmap m, const char *key, const char *value)
{
    CTrieNode ctn = ctrie_lookup(m->map, key);
    if (ctrie_hasvalue(ctn))
	free(ctrie_getvalue(ctn));
    ctrie_setvalue(ctn, savestring(value));
}

void strmap_unset(strmap m, const char *key)
{
    void *oldval = ctrie_unset(m->map, key);
    if (oldval)
	free(oldval);
}

char* strmap_get(strmap m, const char *key)
{
    return ctrie_get(m->map, key);
}

